/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct;

public class ApplicationException
extends Exception {
    private static final long serialVersionUID = -495731838035883308L;
    private int status;
    private String source;
    private int line;

    public ApplicationException() {
    }

    public ApplicationException(String message) {
        super(message);
    }

    public ApplicationException(String message, int status) {
        super(message);
        this.status = status;
    }

    public ApplicationException(String message, Throwable cause) {
        super(message, cause);
    }

    public ApplicationException(String message, Object source, int line) {
        super(message);
        this.source = source.getClass().getName().replace(".", "/") + ".java";
        this.line = line;
    }

    public String getSource() {
        return this.source;
    }

    public int getLine() {
        return this.line;
    }

    public int getStatus() {
        if (this.status == 0) {
            return 500;
        }
        return this.status;
    }

    public Throwable getRootCause(Throwable throwable) {
        Throwable cause = throwable.getCause();
        if (cause != null) {
            return this.getRootCause(cause);
        }
        return throwable;
    }

    public Throwable getRootCause() {
        return this.getRootCause(this);
    }
}

