/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tinystruct.Application;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Context;
import org.tinystruct.application.Method;
import org.tinystruct.http.Protocol;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;

public class Action
implements Method<Object> {
    public static final int MAX_ARGUMENTS = 10;
    private static final Logger logger = Logger.getLogger(Action.class.getName());
    private final int id;
    private final Pattern pattern;
    private final Application app;
    private final String method;
    private final MethodHandle methodHandle;
    private final Class<?>[] parameterTypes;
    private final Class<?> returnType;
    private final int priority;
    private Mode mode;
    private String pathRule;
    private Object[] args = new Object[0];

    public Action(int id, Application app, String pathRule, MethodHandle methodHandle, String method, Class<?> returnType, Class<?>[] parameterTypes, int priority) {
        this.app = app;
        this.id = id;
        this.returnType = returnType;
        this.method = method;
        this.methodHandle = methodHandle;
        this.parameterTypes = parameterTypes;
        this.pathRule = pathRule;
        this.pattern = Pattern.compile(pathRule);
        this.priority = priority;
        this.mode = Mode.All;
    }

    public Action(Action action, Object[] args) {
        this.app = action.app;
        this.args = args;
        this.id = action.getId();
        this.returnType = action.getReturnType();
        this.method = action.getMethod();
        this.methodHandle = action.getMethodHandle();
        this.mode = action.getMode();
        this.parameterTypes = action.getParameterTypes();
        this.pathRule = action.getPathRule();
        this.pattern = action.getPattern();
        this.priority = action.getPriority();
    }

    public Action(int id, Application app, String pathRule, MethodHandle methodHandle, String method, Class<?> returnType, Class<?>[] parameterTypes, int priority, Mode mode) {
        this(id, app, pathRule, methodHandle, method, returnType, parameterTypes, priority);
        this.mode = mode;
    }

    public int getPriority() {
        return this.priority;
    }

    public MethodHandle getMethodHandle() {
        return this.methodHandle;
    }

    public String getMethod() {
        return this.method;
    }

    public int getId() {
        return this.id;
    }

    public String getApplicationName() {
        return this.app.getName();
    }

    public void setContext(Context context) {
        this.app.init(context);
    }

    public String getPathRule() {
        return this.pathRule;
    }

    public void setPathRule(String path) {
        this.pathRule = path;
    }

    @Override
    public Object execute(Object[] args) throws ApplicationException {
        if (this.methodHandle != null) {
            Class<?>[] types;
            Application app;
            Context context = this.app.getContext();
            if (context == null || (app = this.app.getInstance(context)) == null) {
                app = this.app;
            }
            Object[] arguments = (types = this.getParameterTypes()).length > 0 ? this.getArguments(app, args, types, context) : new Object[]{app};
            try {
                Object result = this.methodHandle.invokeWithArguments(arguments);
                if (this.getReturnType().isAssignableFrom(Void.TYPE)) {
                    app.destroy();
                    if (!app.isTemplateRequired()) {
                        return null;
                    }
                    return app.toString();
                }
                return result;
            }
            catch (InvocationTargetException e) {
                throw new ApplicationException(this.method + ": " + e.getTargetException().getMessage(), e.getTargetException());
            }
            catch (Throwable e) {
                throw new ApplicationException(this.method + ": " + e.getMessage(), e);
            }
        }
        logger.warning("Unsupported Operation.");
        throw new UnsupportedOperationException();
    }

    private Class<?> getReturnType() {
        return this.returnType;
    }

    private Class<?>[] getParameterTypes() {
        return this.parameterTypes;
    }

    public Object execute() throws ApplicationException {
        if (this.app == null) {
            throw new ApplicationException("Undefined Application.");
        }
        if (this.app.getContext() != null && this.app.getContext().getAttribute("--help") != null) {
            return this.app.help();
        }
        return this.execute(this.args);
    }

    private Object[] getArguments(Application instance, Object[] args, Class<?>[] types, Context context) {
        Object[] arguments = new Object[types.length + 1];
        arguments[0] = instance;
        if (types.length == 0) {
            return arguments;
        }
        for (int n = 0; n < types.length; ++n) {
            Object arg;
            Class<Protocol> targetType = types[n];
            Object object = arg = args != null && args.length > n ? args[n] : null;
            if (arg != null) {
                arguments[n + 1] = this.convertArgument(arg, targetType);
            }
            if (context == null) continue;
            if (targetType.isAssignableFrom(Request.class) && context.getAttribute("HTTP_REQUEST") != null) {
                arguments[n + 1] = context.getAttribute("HTTP_REQUEST");
                continue;
            }
            if (!targetType.isAssignableFrom(Response.class) || context.getAttribute("HTTP_RESPONSE") == null) continue;
            arguments[n + 1] = context.getAttribute("HTTP_RESPONSE");
        }
        return arguments;
    }

    private Object convertArgument(Object arg, Class<?> targetType) {
        if (arg == null) {
            return null;
        }
        String _arg = String.valueOf(arg);
        try {
            if (Date.class.isAssignableFrom(targetType)) {
                return this.parseDate(_arg);
            }
            if (targetType.isPrimitive() || Number.class.isAssignableFrom(targetType)) {
                return this.parsePrimitive(_arg, targetType);
            }
            if (Boolean.TYPE.isAssignableFrom(targetType) || Boolean.class.isAssignableFrom(targetType)) {
                return Boolean.valueOf(_arg);
            }
            if (targetType.isEnum()) {
                return Enum.valueOf(targetType, _arg);
            }
            return arg;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Error converting argument: " + _arg, e);
        }
    }

    private Date parseDate(String dateString) throws ParseException {
        String defaultDateFormat = "yyyy-MM-dd HH:mm:ss";
        String extendedDateFormat = "yyyy-MM-dd HH:mm:ss z";
        SimpleDateFormat formatter = dateString.length() < extendedDateFormat.length() ? new SimpleDateFormat(defaultDateFormat) : new SimpleDateFormat(extendedDateFormat);
        return formatter.parse(dateString);
    }

    private Object parsePrimitive(String arg, Class<?> targetType) {
        switch (targetType.getName()) {
            case "int": 
            case "java.lang.Integer": {
                return arg == null ? 0 : Integer.parseInt(arg);
            }
            case "long": 
            case "java.lang.Long": {
                return arg == null ? 0L : Long.parseLong(arg);
            }
            case "float": 
            case "java.lang.Float": {
                return Float.valueOf(arg == null ? 0.0f : Float.parseFloat(arg));
            }
            case "double": 
            case "java.lang.Double": {
                return arg == null ? 0.0 : Double.parseDouble(arg);
            }
            case "boolean": 
            case "java.lang.Boolean": {
                return Boolean.parseBoolean(arg);
            }
            case "char": 
            case "java.lang.Character": {
                return Character.valueOf(arg == null || arg.isEmpty() ? (char)'\u0000' : arg.charAt(0));
            }
            case "short": 
            case "java.lang.Short": {
                return arg == null ? (short)0 : Short.parseShort(arg);
            }
            case "byte": 
            case "java.lang.Byte": {
                return arg == null ? (byte)0 : Byte.parseByte(arg);
            }
        }
        throw new IllegalArgumentException("Unsupported type: " + targetType.getName());
    }

    public void setArguments(Object[] args) {
        this.args = (Object[])args.clone();
    }

    public Pattern getPattern() {
        return this.pattern;
    }

    public Mode getMode() {
        return this.mode;
    }

    public static enum Mode {
        CLI,
        Web,
        All;

    }
}

