/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.tinystruct.Application;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.application.Action;
import org.tinystruct.data.component.Cache;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;
import org.tinystruct.system.cli.CommandLine;
import org.tinystruct.system.util.StringUtilities;

public final class ActionRegistry {
    private static final Map<String, List<Action>> patternGroups = new ConcurrentHashMap<String, List<Action>>();
    private static final Map<String, CommandLine> commands = new ConcurrentHashMap<String, CommandLine>();
    private final Set<String> paths = new HashSet<String>();

    private ActionRegistry() {
    }

    public static ActionRegistry getInstance() {
        return SingletonHolder.INSTANCE;
    }

    public void set(Application app, String path, String methodName) {
        this.set(app, path, methodName, Action.Mode.All);
    }

    public void set(Application app, String path, String methodName, Action.Mode mode) {
        if (path == null || methodName == null) {
            throw new IllegalArgumentException("Path or methodName cannot be null.");
        }
        this.paths.add(path);
        this.initializePatterns(app, path, methodName, mode);
    }

    public void set(Application app, String path, String methodName, String method) {
        this.set(app, path, methodName);
    }

    public void set(Action action) {
        if (action == null || action.getPathRule() == null) {
            throw new IllegalArgumentException("Action or pathRule cannot be null.");
        }
        String group = this.extractGroupFromPattern(action.getPathRule());
        List actions = patternGroups.getOrDefault(group, new ArrayList());
        actions.add(action);
        patternGroups.put(group, actions);
    }

    public Action get(String path) {
        Action bestMatch = null;
        Object[] args = new Object[]{};
        int bestPriority = Integer.MIN_VALUE;
        String group = this.extractGroupFromPath(path);
        List actions = patternGroups.getOrDefault(group, new ArrayList());
        for (Action action : actions) {
            Matcher matcher = action.getPattern().matcher(path);
            if (!matcher.matches() || action.getPriority() <= bestPriority) continue;
            args = new Object[matcher.groupCount()];
            for (int i = 0; i < matcher.groupCount(); ++i) {
                args[i] = matcher.group(i + 1);
            }
            bestMatch = action;
            bestPriority = action.getPriority();
        }
        return bestMatch != null ? new Action(bestMatch, args) : null;
    }

    public boolean remove(Action action) {
        String group = this.extractGroupFromPattern(action.getPathRule());
        List<Action> actions = patternGroups.get(group);
        if (actions != null && !actions.isEmpty()) {
            return actions.remove(action);
        }
        return false;
    }

    public Collection<Action> list() {
        return patternGroups.values().stream().flatMap(Collection::stream).collect(Collectors.toList());
    }

    public Collection<String> paths() {
        return this.paths;
    }

    public Action getAction(String path) {
        Action action = this.get(path);
        if (action == null) {
            action = this.get(new StringUtilities(path).removeTrailingSlash());
        }
        return action;
    }

    public CommandLine getCommand(String path) {
        return commands.get(path);
    }

    public Action getAction(String path, String method) {
        return this.getAction(path);
    }

    private synchronized void initializePatterns(Application app, String path, String methodName, Action.Mode mode) {
        Class<?> clazz = app.getClass();
        Method[] methods = this.getMethods(methodName, clazz);
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        CommandLine cli = app.getCommandLines().get(path);
        if (cli != null) {
            commands.put(path, cli);
        }
        String group = this.extractGroupFromPath(path);
        String patternPrefix = "^/?" + path;
        for (Method m : methods) {
            String expression;
            if (null == m) continue;
            Class<?>[] types = m.getParameterTypes();
            int priority = 0;
            if (types.length > 0) {
                StringBuilder patterns = new StringBuilder();
                for (Class<?> type : types) {
                    if (Request.class.isAssignableFrom(type) || Response.class.isAssignableFrom(type)) continue;
                    String[] patternWithPriority = this.getPatternForType(type).split(":");
                    String patternForType = patternWithPriority[0];
                    priority += Integer.parseInt(patternWithPriority[1]);
                    String pattern = "(" + patternForType + ")";
                    if (patterns.length() != 0) {
                        patterns.append("/");
                    }
                    patterns.append(pattern);
                }
                expression = patterns.length() > 0 ? patternPrefix + "/" + String.valueOf(patterns) + "$" : patternPrefix + "$";
            } else {
                expression = patternPrefix + "$";
            }
            try {
                MethodHandle handle = lookup.findVirtual(clazz, methodName, MethodType.methodType(m.getReturnType(), types));
                List actions = patternGroups.getOrDefault(group, new ArrayList());
                Action action = mode == Action.Mode.All ? new Action(actions.size(), app, expression, handle, m.getName(), m.getReturnType(), m.getParameterTypes(), priority) : new Action(actions.size(), app, expression, handle, m.getName(), m.getReturnType(), m.getParameterTypes(), priority, mode);
                actions.add(action);
                patternGroups.put(group, actions);
            }
            catch (IllegalAccessException e) {
                throw new ApplicationRuntimeException(e);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private String getPatternForType(Class<?> type) {
        if (Integer.TYPE.isAssignableFrom(type) || Integer.class.isAssignableFrom(type)) {
            return "-?\\d+:2";
        }
        if (Long.TYPE.isAssignableFrom(type) || Long.class.isAssignableFrom(type)) {
            return "-?\\d+:2";
        }
        if (Float.TYPE.isAssignableFrom(type) || Float.class.isAssignableFrom(type)) {
            return "-?\\d+(\\.\\d+)?:3";
        }
        if (Double.TYPE.isAssignableFrom(type) || Double.class.isAssignableFrom(type)) {
            return "-?\\d+(\\.\\d+)?:3";
        }
        if (Short.TYPE.isAssignableFrom(type) || Short.class.isAssignableFrom(type)) {
            return "-?\\d+:2";
        }
        if (Byte.TYPE.isAssignableFrom(type) || Byte.class.isAssignableFrom(type)) {
            return "\\d+:2";
        }
        if (Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type)) {
            return "true|false:3";
        }
        if (Character.TYPE.isAssignableFrom(type) || Character.class.isAssignableFrom(type)) {
            return ".{1}:1";
        }
        if (String.class.isAssignableFrom(type)) {
            return "[^/]+:1";
        }
        return "[^/]+:0";
    }

    private String extractGroupFromPattern(String pattern) {
        String cleanedPattern = pattern.replaceAll("^\\^/\\?|\\$$", "");
        String[] segments = cleanedPattern.split("/");
        if (segments.length > 0 && !segments[0].startsWith("(") && !segments[0].isEmpty()) {
            return segments[0];
        }
        return "other";
    }

    private String extractGroupFromPath(String path) {
        if (path == null || path.isEmpty()) {
            return "other";
        }
        String[] parts = path.replaceAll("^/|/$", "").split("/");
        return parts.length > 0 ? parts[0] : "other";
    }

    private Method[] getMethods(String methodName, Class<?> clazz) {
        String key;
        Cache instance = Cache.getInstance();
        Method[] methods = (Method[])instance.get(key = clazz.getName() + ":" + methodName);
        if (methods == null) {
            methods = (Method[])Arrays.stream(clazz.getMethods()).filter(m -> m.getName().equals(methodName)).toArray(Method[]::new);
            instance.set(key, methods);
        }
        return methods;
    }

    private static class SingletonHolder {
        private static final ActionRegistry INSTANCE = new ActionRegistry();

        private SingletonHolder() {
        }
    }
}

