/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.util.Map;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Logger;
import org.tinystruct.Application;
import org.tinystruct.system.scheduling.Scheduler;
import org.tinystruct.system.scheduling.TimeIterator;

public final class Container
extends TimerTask {
    private static final Logger logger = Logger.getLogger(Container.class.getName());
    private final Map<String, Application> applicationMap = new ConcurrentHashMap<String, Application>(16);

    private Container() {
        Scheduler.getInstance().schedule(this, new TimeIterator(0, 0, 0), 1800000L);
    }

    public static Container getInstance() {
        return SingletonHolder.container;
    }

    @Override
    public void run() {
        for (String appId : this.applicationMap.keySet()) {
            this.applicationMap.remove(appId);
            logger.fine(appId + " removed.");
        }
    }

    public void put(String appId, Application app) {
        this.applicationMap.put(appId, app);
    }

    public boolean containsKey(String appId) {
        return this.applicationMap.containsKey(appId);
    }

    public Application get(String appId) {
        return this.applicationMap.get(appId);
    }

    public void remove(String appId) {
        this.applicationMap.remove(appId);
    }

    private static final class SingletonHolder {
        static final Container container = new Container();

        private SingletonHolder() {
        }
    }
}

