/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.system.template.variable.Variable;

public final class SharedVariables {
    private static final String PREFIX_SHARED_VARIABLE_NAME = "[%";
    private static final String SUFFIX_SHARED_VARIABLE_NAME = "%]";
    private static final ConcurrentHashMap<String, SharedVariables> group = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Variable<?>> variableMap = new ConcurrentHashMap();

    public static SharedVariables getInstance(String group) {
        return SharedVariables.group.computeIfAbsent(group, k -> new SharedVariables());
    }

    public Variable<?> getVariable(String variable) {
        return this.variableMap.get(PREFIX_SHARED_VARIABLE_NAME + variable + SUFFIX_SHARED_VARIABLE_NAME);
    }

    public void setVariable(Variable<?> variable, boolean force) {
        String variableName = PREFIX_SHARED_VARIABLE_NAME + variable.getName() + SUFFIX_SHARED_VARIABLE_NAME;
        this.saveVariable(variableName, variable, force);
    }

    private void saveVariable(String variableName, Variable<?> variable, boolean force) {
        if (force || !this.variableMap.containsKey(variableName)) {
            this.variableMap.put(variableName, variable);
        } else {
            this.variableMap.putIfAbsent(variableName, variable);
        }
    }

    public Map<String, Variable<?>> getVariables() {
        return this.variableMap;
    }
}

