/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.application;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.component.Builder;
import org.tinystruct.system.template.variable.DataType;
import org.tinystruct.system.template.variable.StringVariable;
import org.tinystruct.system.template.variable.Variable;

public class Variables {
    private static final String PREFIX_VARIABLE_NAME = "{%";
    private static final String SUFFIX_VARIABLE_NAME = "%}";
    private static final ThreadLocal<ConcurrentHashMap<String, Variables>> group = ThreadLocal.withInitial(ConcurrentHashMap::new);
    protected final ConcurrentHashMap<String, Variable<?>> variableMap = new ConcurrentHashMap();
    private static final Logger logger = Logger.getLogger(Variables.class.getName());

    private Variables() {
    }

    public static Variables getInstance(String group) {
        return Variables.group.get().computeIfAbsent(group, k -> new Variables());
    }

    public void setVariable(Variable<?> variable, boolean force) {
        String variableName = PREFIX_VARIABLE_NAME + variable.getName() + SUFFIX_VARIABLE_NAME;
        this.saveVariable(variableName, variable, force);
    }

    protected void saveVariable(String variableName, Variable<?> variable, boolean force) {
        if (force || !this.variableMap.containsKey(variableName)) {
            if (variable.getType() == DataType.OBJECT) {
                this.processObjectVariable(variableName, variable);
            } else {
                this.variableMap.put(variableName, variable);
            }
        } else {
            this.variableMap.putIfAbsent(variableName, variable);
        }
    }

    private void processObjectVariable(String variableName, Variable<?> variable) {
        Builder builder = new Builder();
        try {
            builder.parse(variable.getValue().toString());
            for (Map.Entry entry : builder.entrySet()) {
                String newVariableName = PREFIX_VARIABLE_NAME + variable.getName() + "." + (String)entry.getKey() + SUFFIX_VARIABLE_NAME;
                String value = entry.getValue().toString();
                this.variableMap.put(newVariableName, new StringVariable(newVariableName, value));
            }
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public Variable<?> getVariable(String variable) {
        return this.variableMap.get(PREFIX_VARIABLE_NAME + variable + SUFFIX_VARIABLE_NAME);
    }

    public Map<String, Variable<?>> getVariables() {
        return this.variableMap;
    }
}

