/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data;

import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.repository.Type;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;

final class ConnectionManager
implements Runnable {
    private static final Logger logger = Logger.getLogger(ConnectionManager.class.getName());
    private final ConcurrentLinkedQueue<Connection> connections;
    private final String driverName;
    private String url;
    private String user;
    private String password;
    private final int maxConnections;
    private final ExecutorService executor = Executors.newSingleThreadExecutor();
    private final Lock lock = new ReentrantLock();
    private String database;
    private volatile boolean pending;

    private ConnectionManager() {
        this.connections = new ConcurrentLinkedQueue();
        Settings config = new Settings();
        this.driverName = (String)config.get("driver");
        this.loadDatabaseDriver();
        this.loadDatabaseConfig(config);
        this.maxConnections = !((String)config.get("database.connections.max")).trim().isEmpty() ? Integer.parseInt((String)config.get("database.connections.max")) : 0;
        this.pending = false;
    }

    public static ConnectionManager getInstance() {
        return SingletonHolder.manager;
    }

    private void loadDatabaseDriver() {
        try {
            assert (this.driverName != null && !this.driverName.isEmpty());
            Class.forName(this.driverName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException(e.getMessage(), e);
        }
    }

    private void loadDatabaseConfig(Configuration<String> config) {
        this.database = config.get("database").trim();
        String dbUrl = config.get("database.url");
        String dbUser = config.get("database.user");
        String dbPassword = config.get("database.password").trim();
        String dbType = this.getConfiguredType().name().toLowerCase();
        if (null != dbUrl && !"h2".equalsIgnoreCase(dbType) && !"sqlite".equalsIgnoreCase(dbType)) {
            try {
                URI dbUri = dbUrl.startsWith("jdbc:" + dbType + "://") ? new URI(dbUrl.substring("jdbc:".length())) : (!dbUrl.startsWith(dbType + "://") ? new URI(dbType + "://" + dbUrl) : new URI(dbUrl));
                if (dbUri.getUserInfo() != null) {
                    dbUser = dbUri.getUserInfo().split(":")[0];
                    dbPassword = dbUri.getUserInfo().split(":")[1];
                }
                StringBuilder builder = new StringBuilder();
                builder.append("jdbc:").append(dbType).append("://");
                builder.append(dbUri.getHost());
                builder.append(":");
                if (dbUri.getPort() != -1) {
                    builder.append(dbUri.getPort());
                } else {
                    builder.append(3306);
                }
                if (dbUri.getPath() != null) {
                    builder.append(dbUri.getPath().replaceAll("//", "/"));
                }
                if (dbUri.getQuery() != null) {
                    builder.append("?");
                    builder.append(dbUri.getQuery());
                }
                dbUrl = builder.toString();
            }
            catch (URISyntaxException e) {
                logger.severe(e.getMessage());
            }
        }
        this.url = dbUrl;
        this.user = dbUser;
        this.password = dbPassword;
    }

    private Type getConfiguredType() {
        int index = -1;
        int length = Type.values().length;
        for (int i = 0; i < length; ++i) {
            if (!this.driverName.contains(Type.values()[i].name().toLowerCase())) continue;
            index = i;
            break;
        }
        switch (index) {
            case 0: {
                return Type.MySQL;
            }
            case 1: {
                return Type.SQLServer;
            }
            case 2: {
                return Type.SQLite;
            }
            case 3: {
                return Type.H2;
            }
        }
        return Type.MySQL;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    public void flush(Connection connection) {
        this.lock.lock();
        try {
            this.connections.add(connection);
            if (this.connections.size() == 1) {
                return;
            }
            if (this.connections.size() > this.maxConnections && !this.pending) {
                this.pending = true;
                logger.severe("The connection pool size (" + this.connections.size() + ") is out of the max number.");
                this.executor.submit(this);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    public Connection getConnection() throws ApplicationException {
        Connection connection;
        block7: {
            this.lock.lock();
            try {
                if (!this.connections.isEmpty()) {
                    connection = this.connections.poll();
                    try {
                        if (connection.isClosed()) {
                            logger.severe("Found an invalid connection, removing it.");
                            connection = this.getConnection();
                        }
                        break block7;
                    }
                    catch (SQLException ex) {
                        this.handleSQLException("Error while checking connection status.", ex);
                        connection = this.getConnection();
                    }
                    break block7;
                }
                connection = this.createNewConnection();
            }
            finally {
                this.lock.unlock();
            }
        }
        return connection;
    }

    private Connection createNewConnection() throws ApplicationException {
        try {
            Connection connection = this.user == null || this.user.trim().isEmpty() ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.user, this.password);
            logger.log(Level.INFO, "System default database: " + connection.getCatalog());
            if (!this.database.isEmpty() && !connection.getCatalog().equalsIgnoreCase(this.database)) {
                connection.setCatalog(this.database);
            }
            return connection;
        }
        catch (SQLException ex) {
            throw new ApplicationException(ex.getMessage(), ex);
        }
    }

    public int size() {
        return this.connections.size();
    }

    @Override
    public void run() {
        this.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        block12: {
            this.lock.lock();
            try {
                if (!this.pending) break block12;
                while (this.connections.size() > this.maxConnections) {
                    try {
                        Connection current = this.connections.poll();
                        try {
                            assert (current != null);
                            logger.info("Released 1 connection.");
                        }
                        finally {
                            if (current == null) continue;
                            current.close();
                        }
                    }
                    catch (SQLException ex) {
                        this.handleSQLException("Error while closing connection.", ex);
                    }
                }
                this.pending = false;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void shutdownExecutor() throws InterruptedException {
        logger.info("Shutting down executor...");
        this.executor.shutdown();
        if (!this.executor.awaitTermination(10L, TimeUnit.SECONDS)) {
            logger.warning("Executor did not terminate in the specified time. Forcing shutdown...");
            this.executor.shutdownNow();
        }
        logger.info("Executor shut down successfully.");
    }

    private void handleSQLException(String message, SQLException ex) {
        logger.log(Level.WARNING, message + " Message: " + ex.getMessage(), ex);
    }

    private static final class SingletonHolder {
        static final ConnectionManager manager = new ConnectionManager();

        private SingletonHolder() {
        }
    }

    private static enum DatabaseType {
        MYSQL,
        SQLSERVER,
        SQLITE,
        H2;

    }
}

