/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data;

import java.io.Closeable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.ConnectionManager;
import org.tinystruct.data.tools.SQLInjectionDetector;

public class DatabaseOperator
implements Closeable {
    private static final Logger logger = Logger.getLogger(DatabaseOperator.class.getName());
    private static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";
    private static final int MAX_RETRIES = 3;
    private static final long RETRY_DELAY_MS = 1000L;
    private final ConnectionManager manager;
    private boolean injectionCheckEnabled;
    Connection connection;
    PreparedStatement preparedStatement;
    private ResultSet resultSet;

    public DatabaseOperator() throws ApplicationException {
        this.manager = ConnectionManager.getInstance();
        this.connection = this.manager.getConnection();
        this.injectionCheckEnabled = true;
    }

    public DatabaseOperator(String database) throws ApplicationException {
        this();
        if (this.connection != null) {
            this.setCatalog(database);
        }
    }

    public DatabaseOperator(Connection connection) {
        this.manager = null;
        this.connection = connection;
    }

    public void setCatalog(String database) throws ApplicationException {
        try {
            this.connection.setCatalog(database);
        }
        catch (SQLException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public PreparedStatement preparedStatement(String sql, Object[] parameters) throws ApplicationException {
        if (sql == null || sql.trim().isEmpty()) {
            throw new ApplicationException("SQL statement is NULL or empty");
        }
        if (parameters == null) {
            throw new ApplicationException("Parameters array is NULL");
        }
        try {
            if (this.injectionCheckEnabled) {
                SQLInjectionDetector.checkForUnsafeSQL(sql);
            }
            PreparedStatement preparedStatement = this.connection.prepareStatement(sql);
            for (int n = 0; n < parameters.length; ++n) {
                if (parameters[n] == null) {
                    preparedStatement.setNull(n + 1, 0);
                    continue;
                }
                preparedStatement.setObject(n + 1, parameters[n]);
            }
            return preparedStatement;
        }
        catch (SQLException ex) {
            throw new ApplicationException("Error preparing SQL statement: " + ex.getMessage(), ex);
        }
    }

    public ResultSet executeQuery(PreparedStatement statement) throws ApplicationException {
        this.closeResultSet();
        for (int retry = 0; retry < 3; ++retry) {
            try {
                logger.log(Level.INFO, statement.toString());
                this.resultSet = statement.executeQuery();
                return this.resultSet;
            }
            catch (SQLException e) {
                this.handleSQLException(e, statement);
                if (retry >= 2) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ignore) {
                    Thread.currentThread().interrupt();
                }
                continue;
            }
        }
        throw new ApplicationException("Max retries exceeded for execute");
    }

    public int executeUpdate(PreparedStatement statement) throws ApplicationException {
        int n;
        block8: {
            PreparedStatement preparedStatement = statement;
            try {
                int effect = statement.executeUpdate();
                logger.log(Level.INFO, statement.toString());
                n = effect;
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ApplicationException(e.getMessage(), e);
                }
            }
            preparedStatement.close();
        }
        return n;
    }

    public boolean execute(PreparedStatement statement) throws ApplicationException {
        boolean bl;
        block8: {
            PreparedStatement preparedStatement = statement;
            try {
                bl = statement.execute();
                if (preparedStatement == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (preparedStatement != null) {
                        try {
                            preparedStatement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new ApplicationException(e.getMessage(), e);
                }
            }
            preparedStatement.close();
        }
        return bl;
    }

    public PreparedStatement createPreparedStatement(String sql, boolean scrollable) throws ApplicationException {
        if (this.connection == null) {
            this.connection = this.manager.getConnection();
        }
        try {
            if (this.injectionCheckEnabled) {
                SQLInjectionDetector.checkForUnsafeSQL(sql);
            }
            int resultSetType = scrollable ? 1004 : 1003;
            int resultSetConcurrency = 1007;
            return this.connection.prepareStatement(sql, resultSetType, resultSetConcurrency);
        }
        catch (SQLException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public ResultSet query(String sql) throws ApplicationException {
        this.preparedStatement = this.createPreparedStatement(sql, false);
        return this.executeQuery(this.preparedStatement);
    }

    public int update(String sql) throws ApplicationException {
        this.preparedStatement = this.createPreparedStatement(sql, false);
        return this.executeUpdate(this.preparedStatement);
    }

    public boolean execute(String sql) throws ApplicationException {
        this.preparedStatement = this.createPreparedStatement(sql, false);
        if (this.preparedStatement != null) {
            return this.execute(this.preparedStatement);
        }
        throw new ApplicationException("Prepared statement is null.");
    }

    @Deprecated
    public ResultSet getResultSet() {
        return this.resultSet;
    }

    void closeResultSet() {
        try {
            if (this.resultSet != null) {
                this.resultSet.close();
            }
        }
        catch (SQLException e) {
            logger.severe("ResultSet Close Error: " + e.getMessage());
        }
    }

    @Override
    public void close() {
        this.closeResultSet();
        try {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException(e.getMessage(), e);
        }
        finally {
            if (this.manager != null && this.connection != null) {
                this.manager.flush(this.connection);
            } else if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (SQLException e) {
                    logger.warning("Error closing Connection: " + e.getMessage());
                }
            }
        }
    }

    void handleSQLException(SQLException e, PreparedStatement statement) throws ApplicationException {
        if (e.getSQLState().equals(SQL_STATE_COMMUNICATION_LINK_FAILURE)) {
            this.closeResultSet();
            if (this.manager != null) {
                this.manager.clear();
            }
        } else {
            logger.severe("SQLState(" + e.getSQLState() + ") vendor code(" + e.getErrorCode() + "); Query:" + statement.toString() + " Message:" + e.getMessage());
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public void disableSafeCheck() {
        this.injectionCheckEnabled = false;
    }
}

