/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.Data;
import org.tinystruct.data.MappingManager;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.dom.Attribute;
import org.tinystruct.dom.Document;
import org.tinystruct.dom.Element;

public class Mapping {
    private static final String PROPERTY = "property";
    private static final String NAME = "name";
    private static final String LENGTH = "length";
    private static final String COLUMN = "column";
    private static final String TYPE = "type";
    private static final String GENERATE = "generate";
    private static final String INCREMENT = "increment";
    private static final String ID = "id";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Field getMappedField(Data data) throws ApplicationException {
        Document document;
        String className = data.getClassName();
        String mapFile = data.getClassPath() + className + ".map.xml";
        MappingManager manager = MappingManager.getInstance();
        if (manager.get(className) == null) {
            Class<Mapping> clazz = Mapping.class;
            synchronized (Mapping.class) {
                block24: {
                    if (manager.get(className) == null) {
                        document = new Document();
                        try (InputStream in = data.getClass().getResourceAsStream("/" + mapFile);){
                            boolean loaded = document.load(in);
                            if (!loaded) {
                                throw new ApplicationRuntimeException("Failed to load mapping file: " + mapFile);
                            }
                            manager.set(className, document);
                            break block24;
                        }
                        catch (IOException e) {
                            throw new ApplicationRuntimeException("Failed to load mapping file: " + mapFile + ", Error: " + e.getMessage(), e);
                        }
                    }
                    document = manager.get(className);
                }
                // ** MonitorExit[var5_4] (shouldn't be in output)
            }
        }
        document = manager.get(className);
        {
            Iterator<Element> iterator = document.getRoot().getElementsByTagName("class").iterator();
            List<Element> list = null;
            while (iterator.hasNext()) {
                Element currentElement = iterator.next();
                if (!className.equalsIgnoreCase(currentElement.getAttribute(NAME))) continue;
                switch (data.getRepository().getType().ordinal()) {
                    case 0: {
                        data.setTableName("`" + currentElement.getAttribute("table") + "`");
                        break;
                    }
                    case 1: 
                    case 2: {
                        data.setTableName("[" + currentElement.getAttribute("table") + "]");
                        break;
                    }
                    default: {
                        data.setTableName(currentElement.getAttribute("table"));
                    }
                }
                list = currentElement.getChildNodes();
                break;
            }
            Field field = new Field();
            if (list != null && !list.isEmpty()) {
                for (Element currentElement : list) {
                    FieldInfo fieldInfo;
                    if (currentElement.getName().equalsIgnoreCase(ID)) {
                        fieldInfo = new FieldInfo();
                        fieldInfo.append(ID, currentElement.getAttribute(NAME));
                        fieldInfo.append(NAME, currentElement.getAttribute(NAME));
                        fieldInfo.append(INCREMENT, currentElement.getAttribute(INCREMENT));
                        fieldInfo.append(GENERATE, currentElement.getAttribute(GENERATE));
                        fieldInfo.append(TYPE, currentElement.getAttribute(TYPE));
                        fieldInfo.append(COLUMN, currentElement.getAttribute(COLUMN));
                        fieldInfo.append(LENGTH, currentElement.getAttribute(LENGTH));
                        if (Boolean.parseBoolean(currentElement.getAttribute(GENERATE))) {
                            data.setId(UUID.randomUUID().toString());
                            fieldInfo.append("value", data.getId());
                        }
                        field.append(fieldInfo.getName(), fieldInfo);
                    }
                    if (!currentElement.getName().equalsIgnoreCase(PROPERTY)) continue;
                    fieldInfo = new FieldInfo();
                    List<Attribute> attributes = currentElement.getAttributes();
                    for (Attribute attribute : attributes) {
                        fieldInfo.append(attribute.name, attribute.value);
                    }
                    field.append(fieldInfo.getName(), fieldInfo);
                }
            }
            return field;
        }
    }
}

