/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.system.Settings;

public class VectorOperator
extends DatabaseOperator {
    private static final Logger logger = Logger.getLogger(VectorOperator.class.getName());
    private static final String SQL_STATE_COMMUNICATION_LINK_FAILURE = "08S01";

    public VectorOperator() throws ApplicationException {
        super(VectorOperator.initializeConnection());
    }

    private static Connection initializeConnection() throws ApplicationException {
        Settings context = new Settings();
        String driver = ((String)context.get("vector.database.driver")).isEmpty() ? "org.sqlite.JDBC" : (String)context.get("vector.database.driver");
        String url = ((String)context.get("vector.database.url")).isEmpty() ? "jdbc:sqlite:src/main/resources/vector.db" : (String)context.get("vector.database.url");
        try {
            Class.forName(driver);
            return DriverManager.getConnection(url);
        }
        catch (ClassNotFoundException | SQLException e) {
            throw new ApplicationRuntimeException(e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        this.closeResultSet();
        try {
            if (this.preparedStatement != null) {
                this.preparedStatement.close();
            }
        }
        catch (SQLException e) {
            throw new ApplicationRuntimeException(e.getMessage(), e);
        }
        finally {
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException sQLException) {}
        }
    }

    @Override
    public void handleSQLException(SQLException e, PreparedStatement statement) throws ApplicationException {
        if (SQL_STATE_COMMUNICATION_LINK_FAILURE.equals(e.getSQLState())) {
            this.closeResultSet();
            try {
                if (this.connection != null && !this.connection.isClosed()) {
                    this.connection.close();
                }
            }
            catch (SQLException sQLException) {}
        } else {
            logger.severe("SQLState(" + e.getSQLState() + ") vendor code(" + e.getErrorCode() + "); Query: " + String.valueOf(statement) + " Message: " + e.getMessage());
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public Connection getConnection() {
        return this.connection;
    }
}

