/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.Data;
import org.tinystruct.data.Mapping;
import org.tinystruct.data.Repository;
import org.tinystruct.data.component.Condition;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;
import org.tinystruct.data.repository.Type;
import org.tinystruct.system.Settings;
import org.tinystruct.system.util.ClassInfo;

public abstract class AbstractData
implements Data {
    private static final Logger logger = Logger.getLogger(AbstractData.class.getName());
    private static Repository repository;
    protected Object Id;
    private String classPath;
    private String className;
    private String table;
    private Field readyFields;
    private final StringBuilder allFields = new StringBuilder();
    private String fields;
    private String orderBy;

    public AbstractData() {
        this.className = this.getClass().getSimpleName();
        try {
            this.classPath = new ClassInfo(this).getClassPath();
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, "Failed to get class path: {0}", e.getMessage());
        }
        this.initializeFields();
    }

    private static Repository initializeRepository() throws ApplicationException {
        Settings properties = new Settings("/application.properties");
        String driver = (String)properties.get("driver");
        if (driver == null || driver.trim().isEmpty()) {
            throw new ApplicationRuntimeException("Database connection driver is not configured in application.properties.");
        }
        for (Type type : Type.values()) {
            if (!driver.toLowerCase().contains(type.name().toLowerCase())) continue;
            return type.createRepository();
        }
        throw new ApplicationException("Unsupported database driver: " + driver);
    }

    private void initializeFields() {
        try {
            this.readyFields = Mapping.getMappedField(this);
            for (Map.Entry entry : this.readyFields.entrySet()) {
                if (this.allFields.length() > 0) {
                    this.allFields.append(",");
                }
                this.allFields.append(((FieldInfo)entry.getValue()).getColumnName());
            }
            this.fields = this.allFields.toString();
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, "Failed to initialize fields: {0}", e.getMessage());
        }
    }

    @Override
    public String getClassPath() {
        return this.classPath;
    }

    @Override
    public Object setId(Object id) {
        this.Id = id;
        if (this.readyFields != null && this.readyFields.containsKey("Id")) {
            this.readyFields.get("Id").set("value", this.Id);
        }
        return this.Id;
    }

    @Override
    public Object getId() {
        return this.Id;
    }

    protected Object setField(String fieldName, Object fieldValue) {
        if (this.readyFields.containsKey(fieldName)) {
            this.readyFields.get(fieldName).set("value", fieldValue);
            return fieldValue;
        }
        return null;
    }

    protected Timestamp setFieldAsTimestamp(String fieldName, Timestamp fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return fieldValue;
        }
        return Timestamp.valueOf("2009-03-20");
    }

    protected Date setFieldAsDate(String fieldName, Date fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return fieldValue;
        }
        return new Date();
    }

    protected LocalDateTime setFieldAsLocalDateTime(String fieldName, LocalDateTime fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return fieldValue;
        }
        return LocalDateTime.now();
    }

    protected int setFieldAsInt(String fieldName, int fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return Integer.parseInt(t.toString());
        }
        return -1;
    }

    protected String setFieldAsString(String fieldName, String fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return t.toString();
        }
        return null;
    }

    protected boolean setFieldAsBoolean(String fieldName, boolean fieldValue) {
        Object t = this.setField(fieldName, fieldValue);
        if (t != null) {
            return Boolean.parseBoolean(t.toString());
        }
        return false;
    }

    private void validateTableName() throws ApplicationException {
        if (this.table == null || this.table.trim().isEmpty()) {
            throw new ApplicationException("Table name is not set.");
        }
    }

    @Override
    public boolean append() throws ApplicationException {
        this.validateTableName();
        return repository.append(this.readyFields, this.table);
    }

    @Override
    public boolean update() throws ApplicationException {
        this.validateTableName();
        return repository.update(this.readyFields, this.table);
    }

    @Override
    public boolean delete() throws ApplicationException {
        this.validateTableName();
        if (this.Id == null) {
            throw new ApplicationException("Cannot delete a record without an ID.");
        }
        return repository.delete(this.Id, this.table);
    }

    @Override
    public Data setRequestFields(String fields) {
        this.fields = fields.equalsIgnoreCase("*") ? this.allFields.toString() : fields;
        return this;
    }

    @Override
    public Data orderBy(String[] fieldNames) {
        StringBuilder orders = new StringBuilder();
        for (String fields : fieldNames) {
            if (orders.length() > 0) {
                orders.append(",").append(fields);
                continue;
            }
            orders.append(fields);
        }
        this.orderBy = orders.toString();
        return this;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        return repository.find(SQL, parameters);
    }

    @Override
    public Table find(Condition condition, Object[] parameters) throws ApplicationException {
        if (this.orderBy != null) {
            condition.orderBy(this.orderBy);
        }
        return this.find(condition.toString(), parameters);
    }

    @Override
    public Table findWith(String where, Object[] parameters) throws ApplicationException {
        Condition condition = new Condition();
        condition.setRequestFields(this.fields);
        return this.find(condition.select(this.table).with(where), parameters);
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        return repository.findOne(SQL, parameters);
    }

    @Override
    public Row findOneById() throws ApplicationException {
        Row row;
        Condition condition = new Condition();
        condition.setRequestFields(this.fields);
        if (this.orderBy != null) {
            condition.orderBy(this.orderBy);
        }
        if (!(row = this.findOne(condition.select(this.table).and("id=?").toString(), new Object[]{this.Id})).isEmpty()) {
            this.setData(row);
        }
        return row;
    }

    @Override
    public Row findOneByKey(String PK, String value) throws ApplicationException {
        Row row;
        Condition condition = new Condition();
        condition.setRequestFields(this.fields);
        if (this.orderBy != null) {
            condition.orderBy(this.orderBy);
        }
        if (!(row = this.findOne(condition.select(this.table).and(PK + "=?").toString(), new Object[]{value})).isEmpty()) {
            this.setData(row);
        }
        return row;
    }

    @Override
    public Table findAll() throws ApplicationException {
        Condition condition = new Condition();
        condition.setRequestFields(this.fields);
        return this.find(condition.select(this.table), new Object[0]);
    }

    @Override
    public Repository getRepository() {
        return repository;
    }

    public abstract void setData(Row var1);

    @Override
    public String getClassName() {
        return this.className;
    }

    protected void setClassName(String className) {
        this.className = className;
    }

    public String getTableName() {
        return this.table;
    }

    @Override
    public void setTableName(String table) {
        this.table = table;
    }

    static {
        try {
            repository = AbstractData.initializeRepository();
        }
        catch (ApplicationException e) {
            logger.log(Level.SEVERE, "Failed to initialize repository: {0}", e.getMessage());
        }
    }
}

