/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.component.Builders;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Struct;
import org.tinystruct.system.util.StringUtilities;

public class Builder
extends HashMap<String, Object>
implements Struct,
Serializable {
    private static final long serialVersionUID = 3484789992424316230L;
    private static final Logger logger = Logger.getLogger(Builder.class.getName());
    public static final char QUOTE = '\"';
    public static final char COMMA = ',';
    public static final char COLON = ':';
    public static final char LEFT_BRACE = '{';
    public static final char RIGHT_BRACE = '}';
    public static final char LEFT_BRACKETS = '[';
    public static final char RIGHT_BRACKETS = ']';
    public static final char ESCAPE_CHAR = '\\';
    public static final Pattern INTEGER = Pattern.compile("^-?\\d+$");
    public static final Pattern DOUBLE = Pattern.compile("^-?\\d+(\\.\\d+)$");
    public static final Pattern BOOLEAN = Pattern.compile("^(true|false)$");
    private int closedPosition = 0;
    private String key = null;
    private Object value = null;

    public Builder() {
    }

    public Builder(String value) {
        this.value = value;
    }

    public Builder(Number value) {
        this.value = value;
    }

    public Builder(String key, Object value) {
        this.key = key;
        this.value = value;
        this.put(key, value);
    }

    @Override
    public Builder put(String key, Object value) {
        super.put(key, value);
        return this;
    }

    public Object getValue() {
        return this.value;
    }

    @Override
    public String toString() {
        if (this.value != null) {
            Object tmp = this.value instanceof String ? "\"" + this.value.toString() + "\"" : this.value.toString();
            if (this.key != null) {
                return "\"" + this.key + "\":" + (String)tmp;
            }
            return tmp;
        }
        StringBuilder buffer = new StringBuilder();
        Set keys = this.entrySet();
        for (Map.Entry entry : keys) {
            Object value = entry.getValue();
            String key = (String)entry.getKey();
            if (value instanceof String || value instanceof StringBuffer || value instanceof StringBuilder) {
                buffer.append('\"').append(key).append('\"').append(':').append('\"').append(StringUtilities.escape(value.toString())).append('\"');
            } else {
                buffer.append('\"').append(key).append('\"').append(':').append(value);
            }
            buffer.append(',');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return "{" + buffer.toString() + "}";
    }

    @Override
    public void parse(String resource) throws ApplicationException {
        if (!(resource = resource.trim()).isEmpty()) {
            if (resource.charAt(0) == '\"') {
                this.parseValue(resource);
            }
            if (resource.charAt(0) != '{' && resource.charAt(resource.length() - 1) != '}') {
                throw new ApplicationException("Invalid data format!");
            }
            if (resource.charAt(0) == '{') {
                this.closedPosition = this.seekPosition(resource);
                String values = resource.substring(1, this.closedPosition - 1);
                this.parseValue(values);
            }
        }
    }

    public int getClosedPosition() {
        return this.closedPosition;
    }

    public void setClosedPosition(int closedPosition) {
        this.closedPosition = closedPosition;
    }

    private void parseValue(String value) throws ApplicationException {
        int COLON_POSITION;
        if (!(value = value.trim()).isEmpty() && value.charAt(0) == '\"' && (COLON_POSITION = value.indexOf(58)) != -1) {
            int start = COLON_POSITION + 1;
            String keyName = value.substring(1, COLON_POSITION - 1);
            int QUOTE_POSITION = keyName.lastIndexOf(34);
            if (QUOTE_POSITION != -1) {
                keyName = keyName.substring(0, QUOTE_POSITION);
            }
            String $value = value.substring(start).trim();
            Object keyValue = null;
            if (!$value.isEmpty()) {
                if ($value.charAt(0) == '\"') {
                    int $end = this.next($value, '\"');
                    keyValue = $value.substring(1, $end - 1).trim();
                    if ($end + 1 < $value.length()) {
                        $value = $value.substring($end + 1);
                        this.parseValue($value);
                    }
                } else if ($value.charAt(0) == '{') {
                    int closedPosition = this.seekPosition($value);
                    String _$value = $value.substring(0, closedPosition);
                    Builder builder = new Builder();
                    builder.parse(_$value);
                    keyValue = builder;
                    if (closedPosition < $value.length()) {
                        _$value = $value.substring(closedPosition + 1);
                        this.parseValue(_$value);
                    }
                } else if ($value.charAt(0) == '[') {
                    Builders builders = new Builders();
                    String remaining = builders.parse($value).trim();
                    keyValue = builders;
                    if (!remaining.isEmpty() && remaining.charAt(0) == ',') {
                        remaining = remaining.substring(1);
                    }
                    this.parseValue(remaining);
                } else if ($value.indexOf(44) != -1) {
                    String _value = $value.substring(0, $value.indexOf(44));
                    keyValue = !_value.isEmpty() ? this.getValue(_value) : _value;
                    $value = $value.substring($value.indexOf(44) + 1);
                    this.parseValue($value);
                } else {
                    keyValue = this.getValue($value);
                }
            }
            this.put(keyName, keyValue);
        }
    }

    private Object getValue(String value) {
        if (value == null || value.trim().isEmpty()) {
            return null;
        }
        if (INTEGER.matcher(value = value.trim()).matches()) {
            try {
                return Integer.parseInt(value);
            }
            catch (NumberFormatException e) {
                try {
                    return Long.parseLong(value);
                }
                catch (NumberFormatException ex) {
                    logger.warning("Failed to parse integer value: " + value);
                }
            }
        }
        if (DOUBLE.matcher(value).matches()) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                logger.warning("Failed to parse double value: " + value);
            }
        }
        if (BOOLEAN.matcher(value.toLowerCase(Locale.ROOT)).matches()) {
            return Boolean.parseBoolean(value);
        }
        if ("null".equalsIgnoreCase(value)) {
            return null;
        }
        return value;
    }

    private int seekPosition(String value) {
        char[] chars = value.toCharArray();
        int n = 0;
        int position = chars.length;
        for (int i = 0; i < position; ++i) {
            char c = chars[i];
            if (c == '{') {
                if (i - 1 >= 0 && chars[i - 1] == '\\') continue;
                ++n;
                continue;
            }
            if (c != '}' || i - 1 >= 0 && chars[i - 1] == '\\') continue;
            --n;
            if (n != 0) continue;
            position = i;
        }
        return position;
    }

    private int next(String value, char character) {
        char[] chars = value.toCharArray();
        int n = 0;
        int position = chars.length;
        for (int i = 0; i < position; ++i) {
            char c = chars[i];
            if (c != character || i - 1 >= 0 && chars[i - 1] == '\\') continue;
            ++n;
            if (n != 2) continue;
            position = i;
        }
        return position;
    }

    @Override
    public Row toData() {
        Row row = new Row();
        Field field = new Field();
        for (Map.Entry entry : this.entrySet()) {
            FieldInfo info = new FieldInfo();
            info.set("name", entry.getKey());
            info.set("value", entry.getValue());
            field.append((String)entry.getKey(), info);
        }
        row.append(field);
        return row;
    }

    public void saveAsFile(File file) throws ApplicationException {
        try (PrintWriter writer = new PrintWriter(file);){
            writer.write(this.toString());
        }
        catch (FileNotFoundException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    @Override
    public int size() {
        return this.keySet().size();
    }
}

