/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.component.Builder;

public class Builders
extends ArrayList<Builder>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Logger logger = Logger.getLogger(Builders.class.getName());

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder();
        for (Object o : this) {
            buffer.append(o);
            buffer.append(',');
        }
        if (buffer.length() > 0) {
            buffer.setLength(buffer.length() - 1);
        }
        return "[" + buffer.toString() + "]";
    }

    public String parse(String value) throws ApplicationException {
        if ((value = value.trim()).isEmpty()) {
            return "";
        }
        if (value.charAt(0) == '[') {
            int end = this.findClosingBracket(value);
            if (end == -1) {
                throw new ApplicationException("Invalid array format: missing closing bracket");
            }
            if (end > 1) {
                this.parseArrayContent(value.substring(1, end));
            }
            return value.substring(Math.min(end + 1, value.length())).trim();
        }
        if (value.charAt(0) == '{') {
            Builder builder = new Builder();
            builder.parse(value);
            this.add(builder);
            int p = builder.getClosedPosition();
            if (p < value.length() && value.charAt(p) == ',') {
                return this.parse(value.substring(p + 1));
            }
        }
        return value;
    }

    private void parseArrayContent(String content) throws ApplicationException {
        if ((content = content.trim()).isEmpty()) {
            return;
        }
        StringBuilder element = new StringBuilder();
        int depth = 0;
        boolean inQuotes = false;
        for (int i = 0; i < content.length(); ++i) {
            char c = content.charAt(i);
            if (c == '\"' && (i == 0 || content.charAt(i - 1) != '\\')) {
                inQuotes = !inQuotes;
                element.append(c);
                continue;
            }
            if (!inQuotes) {
                if (c == '{' || c == '[') {
                    ++depth;
                    element.append(c);
                    continue;
                }
                if (c == '}' || c == ']') {
                    --depth;
                    element.append(c);
                    continue;
                }
                if (c == ',' && depth == 0) {
                    this.addElement(element.toString());
                    element.setLength(0);
                    continue;
                }
                element.append(c);
                continue;
            }
            element.append(c);
        }
        if (element.length() > 0) {
            this.addElement(element.toString());
        }
    }

    private void addElement(String element) throws ApplicationException {
        if ((element = element.trim()).isEmpty()) {
            return;
        }
        if (element.charAt(0) == '\"') {
            String value = element.substring(1, element.length() - 1);
            this.add(new Builder(value));
        } else if (element.charAt(0) == '{') {
            Builder builder = new Builder();
            builder.parse(element);
            this.add(builder);
        } else if (element.charAt(0) == '[') {
            Builder arrayBuilder = new Builder();
            Builders nestedBuilders = new Builders();
            nestedBuilders.parse(element);
            for (Builder b : nestedBuilders) {
                arrayBuilder.put(String.valueOf(arrayBuilder.size()), b.getValue());
            }
            this.add(arrayBuilder);
        } else if (this.isNumber(element)) {
            this.add(new Builder(this.parseNumber(element)));
        } else {
            this.add(new Builder(element));
        }
    }

    private int findClosingBracket(String value) {
        int depth = 0;
        boolean inQuotes = false;
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '\"' && (i == 0 || value.charAt(i - 1) != '\\')) {
                inQuotes = !inQuotes;
                continue;
            }
            if (inQuotes) continue;
            if (c == '[') {
                ++depth;
                continue;
            }
            if (c != ']' || --depth != 0) continue;
            return i;
        }
        return -1;
    }

    private boolean isNumber(String value) {
        return Builder.INTEGER.matcher(value).matches() || Builder.DOUBLE.matcher(value).matches();
    }

    private Number parseNumber(String value) {
        if (value == null || value.isBlank()) {
            throw new IllegalArgumentException("Value cannot be null or empty");
        }
        if ((value = value.trim()).contains(".") || value.contains("e") || value.contains("E")) {
            try {
                return Double.parseDouble(value);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Invalid double value: " + value, e);
            }
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            try {
                return Long.parseLong(value);
            }
            catch (NumberFormatException ex) {
                throw new IllegalArgumentException("Invalid number value: " + value, ex);
            }
        }
    }
}

