/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.io.Serializable;

public class Condition
implements Serializable {
    private static final long serialVersionUID = 7375286601225137163L;
    private final StringBuilder sqlBuilder = new StringBuilder();
    private String table;
    private String fields = "*";
    private String orders = "";

    public Condition select(String table) {
        if (table == null || table.trim().isEmpty()) {
            throw new IllegalArgumentException("Table name must not be null or empty.");
        }
        this.table = table;
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("SELECT ").append(this.fields).append(" FROM ").append(this.table).append(this.orders);
        return this;
    }

    public Condition and(String condition) {
        this.validateCondition(condition);
        this.appendCondition("AND", condition);
        return this;
    }

    public Condition or(String condition) {
        this.validateCondition(condition);
        this.appendCondition("OR", condition);
        return this;
    }

    private void appendCondition(String connector, String condition) {
        String query = this.sqlBuilder.toString();
        if (query.toUpperCase().contains("WHERE")) {
            this.sqlBuilder.append(" ").append(connector).append(" ");
        } else {
            this.sqlBuilder.append(" WHERE ");
        }
        this.sqlBuilder.append(condition.toLowerCase());
    }

    public Condition orderBy(String orders) {
        if (orders == null || orders.trim().isEmpty()) {
            throw new IllegalArgumentException("Order clause must not be null or empty.");
        }
        this.orders = " ORDER BY " + orders.toLowerCase();
        this.sqlBuilder.append(this.orders);
        return this;
    }

    public Condition with(String sql) {
        if (sql == null || sql.trim().isEmpty()) {
            throw new IllegalArgumentException("SQL must not be null or empty.");
        }
        this.sqlBuilder.setLength(0);
        this.sqlBuilder.append("SELECT ").append(this.fields).append(" FROM ").append(this.table).append(" ").append(sql).append(this.orders);
        return this;
    }

    public Condition setRequestFields(String fields) {
        if (fields == null || fields.trim().isEmpty()) {
            throw new IllegalArgumentException("Fields must not be null or empty.");
        }
        this.fields = fields;
        return this;
    }

    public String toString() {
        return this.sqlBuilder.toString().trim();
    }

    private void validateCondition(String condition) {
        if (condition == null || condition.trim().isEmpty()) {
            throw new IllegalArgumentException("Condition must not be null or empty.");
        }
    }
}

