/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.Enumeration;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.data.component.FieldType;

public class FieldInfo
extends ConcurrentHashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private String name;
    private String column;
    private boolean autoIncrement = false;
    private int length = 0;

    public FieldInfo() {
        super(8);
    }

    public FieldInfo(String name) {
        this();
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        if (this.containsKey("name")) {
            this.name = String.valueOf(this.get("name"));
        }
        return this.name;
    }

    public String getColumnName() {
        if (this.containsKey("column")) {
            this.column = String.valueOf(this.get("column"));
        }
        return this.column;
    }

    public int getLength() {
        if (this.containsKey("length")) {
            this.length = Integer.parseInt(String.valueOf(this.get("length")));
        }
        return this.length;
    }

    public boolean autoIncrement() {
        if (this.containsKey("increment")) {
            String value = String.valueOf(this.get("increment"));
            this.autoIncrement = "1".equals(value) ? true : Boolean.parseBoolean(value);
        }
        return this.autoIncrement;
    }

    public void append(String property, Object value) {
        this.set(property, value);
    }

    public void set(String property, Object value) {
        if (property != null && value != null) {
            this.put(property, value);
        }
    }

    public Object value() {
        if (!this.containsKey("value")) {
            return null;
        }
        return this.get("value");
    }

    public String stringValue() {
        Object value = this.value();
        if (value == null) {
            return null;
        }
        return value.toString();
    }

    public double doubleValue() {
        Object value = this.value();
        if (value == null) {
            return 0.0;
        }
        return Double.parseDouble(value.toString());
    }

    public int intValue() {
        Object value = this.value();
        if (value == null) {
            return -1;
        }
        String svalue = value.toString();
        if (svalue.lastIndexOf(46) != -1) {
            svalue = svalue.substring(0, svalue.indexOf(46));
        }
        return Integer.parseInt(svalue);
    }

    public boolean booleanValue() {
        Object value = this.value();
        if (value == null) {
            return false;
        }
        return Boolean.parseBoolean(value.toString());
    }

    public FieldType typeOf(Object object) {
        if (object instanceof Integer) {
            return FieldType.INTEGER;
        }
        if (object instanceof String) {
            return FieldType.STRING;
        }
        if (object instanceof Double) {
            return FieldType.DOUBLE;
        }
        if (object instanceof Float) {
            return FieldType.FLOAT;
        }
        if (object instanceof Long) {
            return FieldType.LONG;
        }
        if (object instanceof Boolean) {
            return FieldType.BOOLEAN;
        }
        if (object instanceof Date) {
            return FieldType.DATE;
        }
        if (object instanceof LocalDateTime) {
            return FieldType.DATETIME;
        }
        return FieldType.STRING;
    }

    @Override
    public String toString() {
        StringBuilder to = new StringBuilder();
        Enumeration f = this.keys();
        while (f.hasMoreElements()) {
            String key = (String)f.nextElement();
            String value = this.get(key).toString().replaceAll("\"", "\\\\\"");
            value = value.replaceAll("'", "\\\\'");
            value = value.replaceAll("\\[", "\\\\[");
            value = value.replaceAll("\\]", "\\\\]");
            value = value.replaceAll("\\{", "\\\\{");
            value = value.replaceAll("\\}", "\\\\}");
            if (to.length() == 0) {
                to.append(" \"").append(key).append("\":\"").append(value).append("\"");
                continue;
            }
            to.append(", \"").append(key).append("\":\"").append(value).append("\"");
        }
        return to.toString();
    }

    public FieldType getType() {
        return FieldType.valueOf(this.get("type").toString());
    }

    public Timestamp timestampValue() {
        Object value = this.value();
        if (value == null) {
            return Timestamp.valueOf("1982-03-20");
        }
        return Timestamp.valueOf(value.toString());
    }

    public Date dateValue() {
        Object value = this.value();
        if (value instanceof Date) {
            return (Date)value;
        }
        return new Date();
    }

    public LocalDateTime localDateTimeValue() {
        Object value = this.value();
        if (value instanceof LocalDateTime) {
            return (LocalDateTime)value;
        }
        return LocalDateTime.now();
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.autoIncrement ? 1231 : 1237);
        result = 31 * result + (this.column == null ? 0 : this.column.hashCode());
        result = 31 * result + this.length;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (!(obj instanceof FieldInfo)) {
            return false;
        }
        FieldInfo other = (FieldInfo)obj;
        if (this.autoIncrement != other.autoIncrement) {
            return false;
        }
        if (this.column == null ? other.column != null : !this.column.equals(other.column)) {
            return false;
        }
        if (this.length != other.length) {
            return false;
        }
        if (this.name == null) {
            return other.name == null;
        }
        return this.name.equals(other.name);
    }
}

