/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.component;

import java.nio.ByteBuffer;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.ApplicationRuntimeException;
import org.tinystruct.data.Data;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.Vector;
import org.tinystruct.data.VectorOperator;
import org.tinystruct.data.component.SearchResult;
import org.tinystruct.data.tools.CosineSimilarity;

public class SQLiteVector
implements Vector {
    private static final Logger LOGGER = Logger.getLogger(SQLiteVector.class.getName());
    private final DatabaseOperator dbOperator;

    public SQLiteVector() {
        try {
            this.dbOperator = new VectorOperator();
            String createTableSQL = "CREATE TABLE IF NOT EXISTS vectors (id INTEGER PRIMARY KEY AUTOINCREMENT,vector BLOB NOT NULL,label TEXT NOT NULL,entity_id INTEGER NOT NULL,entity_type TEXT NOT NULL)";
            this.dbOperator.execute(createTableSQL);
        }
        catch (ApplicationException e) {
            LOGGER.log(Level.SEVERE, "Error initializing SQLite database connection", e);
            throw new ApplicationRuntimeException("Failed to initialize SQLite database connection", e);
        }
    }

    @Override
    public void add(double[] vector, String label, int entityId, String entityType) throws ApplicationException {
        String sql = "INSERT INTO vectors (vector, label, entity_id, entity_type) VALUES (?, ?, ?, ?)";
        try (PreparedStatement statement = this.dbOperator.preparedStatement(sql, new Object[]{this.toByteArray(vector), label, entityId, entityType});){
            this.dbOperator.execute(statement);
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error adding vector to SQLite", e);
            throw new ApplicationException("Failed to add vector to SQLite", e);
        }
    }

    @Override
    public List<SearchResult> search(double[] queryVector, int topK) throws ApplicationException {
        String sql = "SELECT * FROM vectors";
        ArrayList<SearchResult> results = new ArrayList<SearchResult>();
        try (ResultSet resultSet = this.dbOperator.query(sql);){
            while (resultSet.next()) {
                byte[] vectorBytes = resultSet.getBytes("vector");
                double[] vector = this.toDoubleArray(vectorBytes);
                String label = resultSet.getString("label");
                int entityId = resultSet.getInt("entity_id");
                String entityType = resultSet.getString("entity_type");
                double similarity = CosineSimilarity.cosineSimilarity(queryVector, vector);
                results.add(new SearchResult(vector, label, entityId, entityType, similarity));
            }
        }
        catch (SQLException e) {
            LOGGER.log(Level.SEVERE, "Error searching vectors in SQLite", e);
            throw new ApplicationException("Failed to search vectors in SQLite", e);
        }
        results.sort(Comparator.comparingDouble(SearchResult::getSimilarity).reversed());
        return results.subList(0, Math.min(topK, results.size()));
    }

    @Override
    public boolean delete(List<String> ids) throws ApplicationException {
        if (ids == null || ids.isEmpty()) {
            return false;
        }
        String sql = "DELETE FROM vectors WHERE id = ?";
        boolean success = true;
        for (String id : ids) {
            try {
                PreparedStatement statement = this.dbOperator.preparedStatement(sql, new Object[]{id});
                try {
                    int affectedRows = this.dbOperator.executeUpdate(statement);
                    if (affectedRows != 0) continue;
                    success = false;
                    LOGGER.log(Level.WARNING, "No vector found with ID: " + id);
                }
                finally {
                    if (statement == null) continue;
                    statement.close();
                }
            }
            catch (SQLException e) {
                LOGGER.log(Level.SEVERE, "Error deleting vector with ID: " + id, e);
                throw new ApplicationException("Failed to delete vector with ID: " + id, e);
            }
        }
        return success;
    }

    @Override
    public List<Data> similarity(String query) {
        return List.of();
    }

    private double[] toDoubleArray(byte[] bytes) {
        double[] doubles = new double[bytes.length / 8];
        for (int i = 0; i < doubles.length; ++i) {
            doubles[i] = ByteBuffer.wrap(bytes, i * 8, 8).getDouble();
        }
        return doubles;
    }

    private byte[] toByteArray(double[] doubles) {
        ByteBuffer buffer = ByteBuffer.allocate(doubles.length * 8);
        for (double d : doubles) {
            buffer.putDouble(d);
        }
        return buffer.array();
    }
}

