/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.Repository;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.Row;

public abstract class AbstractDataRepository
implements Repository {
    @Override
    public boolean delete(Object Id2, String table) throws ApplicationException {
        String SQL = "DELETE FROM " + table + " WHERE id=?";
        DatabaseOperator operator = new DatabaseOperator();
        try {
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            ps.setObject(1, Id2);
            boolean bl = ps.executeUpdate() > 0;
            operator.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    operator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        Row row = new Row();
        Field field = new Field();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement preparedStatement = operator.preparedStatement(SQL, parameters);
            ResultSet resultSet = operator.executeQuery(preparedStatement);
            int cols = resultSet.getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = resultSet.getMetaData().getColumnName(i + 1);
            }
            if (resultSet.next()) {
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = resultSet.getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo fieldInfo = new FieldInfo();
                    fieldInfo.append("name", fieldName[i]);
                    fieldInfo.append("value", fieldValue[i]);
                    fieldInfo.append("type", fieldInfo.typeOf(v_field));
                    field.append(fieldInfo.getName(), fieldInfo);
                }
                row.append(field);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return row;
    }
}

