/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Enumeration;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.FieldType;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;
import org.tinystruct.data.repository.AbstractDataRepository;
import org.tinystruct.data.repository.Type;

public class MySQLServer
extends AbstractDataRepository {
    public static final String COMMA = ",";

    @Override
    public boolean append(Field ready_fields, String table) throws ApplicationException {
        int i = 0;
        int cols = ready_fields.size();
        String[] columns = new String[cols];
        FieldInfo[] fields = new FieldInfo[cols];
        StringBuilder expressions = new StringBuilder();
        StringBuilder values = new StringBuilder();
        Enumeration keys = ready_fields.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (ready_fields.get(key).autoIncrement()) continue;
            columns[i] = ready_fields.get(key).getColumnName();
            fields[i] = ready_fields.get(key);
            if (expressions.length() == 0) {
                expressions.append("`").append(columns[i]).append("`");
            } else {
                expressions.append(COMMA).append("`").append(columns[i]).append("`");
            }
            if (values.length() == 0) {
                values.append('?');
            } else {
                values.append(COMMA).append('?');
            }
            ++i;
        }
        String SQL = "INSERT INTO " + table + " (" + String.valueOf(expressions) + ") VALUES(" + String.valueOf(values) + ")";
        DatabaseOperator operator = new DatabaseOperator();
        try {
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            this.setParameters(ps, fields);
            boolean bl = ps.executeUpdate() > 0;
            operator.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    operator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ApplicationException("Error appending record: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean update(Field ready_fields, String table) throws ApplicationException {
        String id = "id";
        Object Id2 = null;
        StringBuilder expressions = new StringBuilder();
        int i = 0;
        int cols = ready_fields.size();
        String[] columns = new String[cols];
        FieldInfo[] values = new FieldInfo[cols];
        Enumeration keys = ready_fields.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            if (key.equalsIgnoreCase("Id")) {
                Id2 = ready_fields.get(key).value();
                id = ready_fields.get(key).getColumnName();
                continue;
            }
            columns[i] = ready_fields.get(key).getColumnName();
            values[i] = ready_fields.get(key);
            if (expressions.length() == 0) {
                expressions.append("`").append(columns[i]).append("`").append("=?");
            } else {
                expressions.append(COMMA).append("`").append(columns[i]).append("`").append("=?");
            }
            ++i;
        }
        String SQL = "UPDATE " + table + " SET " + String.valueOf(expressions) + " WHERE " + id + "=?";
        DatabaseOperator operator = new DatabaseOperator();
        try {
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            this.setParameters(ps, values);
            ps.setObject(ready_fields.size(), Id2);
            boolean bl = ps.executeUpdate() > 0;
            operator.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    operator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ApplicationException("Error updating record: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public Type getType() {
        return Type.MySQL;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        Table table = new Table();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement preparedStatement = operator.preparedStatement(SQL, parameters);
            ResultSet resultSet = operator.executeQuery(preparedStatement);
            int cols = resultSet.getMetaData().getColumnCount();
            while (resultSet.next()) {
                Row row = new Row();
                Field fields = new Field();
                for (int i = 0; i < cols; ++i) {
                    Object fieldValue = resultSet.getObject(i + 1);
                    String fieldName = resultSet.getMetaData().getColumnName(i + 1);
                    FieldInfo field = new FieldInfo();
                    field.append("name", fieldName);
                    field.append("value", fieldValue);
                    field.append("type", field.typeOf(fieldValue).getTypeName());
                    fields.append(field.getName(), field);
                }
                row.append(fields);
                table.append(row);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return table;
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        Row row = new Row();
        Field field = new Field();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement preparedStatement = operator.preparedStatement(SQL, parameters);
            ResultSet resultSet = operator.executeQuery(preparedStatement);
            int cols = resultSet.getMetaData().getColumnCount();
            if (resultSet.next()) {
                for (int i = 0; i < cols; ++i) {
                    Object fieldValue = resultSet.getObject(i + 1);
                    String fieldName = resultSet.getMetaData().getColumnName(i + 1);
                    FieldInfo fieldInfo = new FieldInfo();
                    fieldInfo.append("name", fieldName);
                    fieldInfo.append("value", fieldValue);
                    fieldInfo.append("type", fieldInfo.typeOf(fieldValue));
                    field.append(fieldInfo.getName(), fieldInfo);
                }
                row.append(field);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return row;
    }

    private String generateInsertSQL(String[] columns, String table) {
        StringBuilder _columns = new StringBuilder();
        StringBuilder values = new StringBuilder();
        for (String fieldName : columns) {
            if (_columns.length() > 0) {
                _columns.append(", ");
                values.append(", ");
            }
            _columns.append("`").append(fieldName).append("`");
            values.append("?");
        }
        return "INSERT INTO " + table + " (" + String.valueOf(_columns) + ") VALUES (" + String.valueOf(values) + ")";
    }

    private void setParameters(PreparedStatement ps, FieldInfo[] values) throws SQLException {
        int i = 1;
        for (FieldInfo fieldInfo : values) {
            if (fieldInfo == null || fieldInfo.autoIncrement()) continue;
            Object value = fieldInfo.value();
            if ("int".equalsIgnoreCase(fieldInfo.getType().getRealType())) {
                ps.setInt(i++, fieldInfo.intValue());
                continue;
            }
            if (fieldInfo.getType() == FieldType.TEXT) {
                ps.setString(i++, fieldInfo.stringValue());
                continue;
            }
            if (fieldInfo.getType() == FieldType.DATE || fieldInfo.getType() == FieldType.DATETIME) {
                ps.setTimestamp(i++, new Timestamp(fieldInfo.dateValue().getTime()));
                continue;
            }
            if (fieldInfo.getType() == FieldType.BIT) {
                ps.setBoolean(i++, fieldInfo.booleanValue());
                continue;
            }
            ps.setObject(i++, value);
        }
    }
}

