/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.repository;

import io.lettuce.core.RedisClient;
import io.lettuce.core.api.StatefulRedisConnection;
import io.lettuce.core.api.sync.RedisCommands;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Repository;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;
import org.tinystruct.data.repository.Type;

public class RedisServer
implements Repository {
    private final RedisClient client = RedisClient.create((String)"redis://localhost");
    private final StatefulRedisConnection<String, String> connection = this.client.connect();
    private final RedisCommands<String, String> commands = this.connection.sync();

    @Override
    public Type getType() {
        return Type.Redis;
    }

    @Override
    public boolean append(Field ready_fields, String table) throws ApplicationException {
        try {
            for (String fieldName : ready_fields.keySet()) {
                String value = ready_fields.get(fieldName).toString();
                this.commands.hset((Object)table, (Object)fieldName, (Object)value);
            }
            return true;
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to append record to Redis: " + e.getMessage());
        }
    }

    @Override
    public boolean update(Field ready_fields, String table) throws ApplicationException {
        try {
            for (String fieldName : ready_fields.keySet()) {
                String value = ready_fields.get(fieldName).toString();
                this.commands.hset((Object)table, (Object)fieldName, (Object)value);
            }
            return true;
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to update record in Redis: " + e.getMessage());
        }
    }

    @Override
    public boolean delete(Object Id2, String table) throws ApplicationException {
        try {
            this.commands.hdel((Object)table, (Object[])new String[]{Id2.toString()});
            return true;
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to delete record from Redis: " + e.getMessage());
        }
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        try {
            throw new ApplicationException("Find operation not supported for Redis");
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to perform find operation on Redis: " + e.getMessage());
        }
    }

    @Override
    public Row findOne(String SQL, Object[] parameters) throws ApplicationException {
        try {
            throw new ApplicationException("FindOne operation not supported for Redis");
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to perform findOne operation on Redis: " + e.getMessage());
        }
    }
}

