/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.FieldType;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;
import org.tinystruct.data.repository.AbstractDataRepository;
import org.tinystruct.data.repository.Type;

public class SQLServer
extends AbstractDataRepository {
    @Override
    public boolean append(Field ready_fields, String table) throws ApplicationException {
        StringBuilder keys = new StringBuilder();
        StringBuilder dataKeys = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder parameters = new StringBuilder();
        String dot = ",";
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            FieldInfo currentField = ready_fields.get(currentProperty);
            if (currentField.autoIncrement()) continue;
            if ("int".equalsIgnoreCase(currentField.getType().getRealType()) || currentField.getType() == FieldType.TEXT || currentField.getType() == FieldType.BIT || currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append(dot);
                if (currentField.getType() == FieldType.TEXT) {
                    values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(dot);
                } else if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    values.append("'").append(format.format(currentField.value())).append("'").append(dot);
                } else if (currentField.getType() == FieldType.BIT) {
                    if (currentField.value() != null) {
                        values.append("true".equals(currentField.value().toString()) ? 1 : 0).append(dot);
                    } else {
                        values.append("0").append(dot);
                    }
                } else {
                    values.append(currentField.value()).append(dot);
                }
            } else {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append("(").append(currentField.getLength()).append(")").append(dot);
                values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(dot);
            }
            dataKeys.append(currentField.getColumnName()).append(dot);
            keys.append("@").append(currentField.getName()).append(dot);
        }
        dataKeys = new StringBuilder(dataKeys.substring(0, dataKeys.length() - 1));
        keys = new StringBuilder(keys.substring(0, keys.length() - 1));
        values = new StringBuilder(values.substring(0, values.length() - 1));
        parameters = new StringBuilder(parameters.substring(0, parameters.length() - 1));
        table = table.replaceAll("\\[", "").replaceAll("\\]", "");
        String SQL = "if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[" + table + "_APPEND]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)BEGIN exec('CREATE PROCEDURE [dbo].[" + table + "_APPEND] " + String.valueOf(parameters) + " AS INSERT INTO [" + table + "](" + String.valueOf(dataKeys) + ") VALUES(" + String.valueOf(keys) + ")') {call " + table + "_APPEND(" + String.valueOf(values) + ")} END else {call " + table + "_APPEND(" + String.valueOf(values) + ")}";
        try (DatabaseOperator operator = new DatabaseOperator();){
            boolean bl = operator.update(SQL) > 0;
            return bl;
        }
    }

    @Override
    public boolean delete(Object Id2, String table) throws ApplicationException {
        String SQL = "DELETE FROM [" + table + "] WHERE id=?";
        DatabaseOperator operator = new DatabaseOperator();
        try {
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            ps.setObject(1, Id2);
            boolean bl = ps.executeUpdate() > 0;
            operator.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    operator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean update(Field ready_fields, String table) throws ApplicationException {
        StringBuilder parameters = new StringBuilder();
        StringBuilder values = new StringBuilder();
        StringBuilder expressions = new StringBuilder();
        StringBuilder sql = new StringBuilder();
        StringBuilder keys = new StringBuilder();
        String dot = ",";
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            FieldInfo currentField = ready_fields.get(currentProperty);
            if (currentField.autoIncrement()) {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append(",");
                values.append(currentField.value()).append(",");
                continue;
            }
            if ("int".equalsIgnoreCase(currentField.getType().getRealType()) || currentField.getType() == FieldType.TEXT || currentField.getType() == FieldType.BIT || currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append(",");
                if (currentField.getType() == FieldType.TEXT) {
                    values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(",");
                } else if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    values.append("'").append(format.format(currentField.value())).append("'").append(",");
                } else if (currentField.getType() == FieldType.BIT) {
                    values.append("true".equals(currentField.value().toString()) ? 1 : 0).append(",");
                } else {
                    values.append(currentField.value()).append(",");
                }
            } else {
                parameters.append("@").append(currentField.getName()).append(" ").append(currentField.get("type")).append("(").append(currentField.getLength()).append(")").append(",");
                values.append("'").append(currentField.stringValue().replaceAll("'", "''")).append("'").append(",");
            }
            keys.append("@").append(currentField.getName());
            expressions.append("[").append(currentField.getColumnName()).append("]=").append((CharSequence)keys).append(",");
        }
        values.setLength(values.length() - 1);
        expressions.setLength(expressions.length() - 1);
        parameters.setLength(parameters.length() - 1);
        table = table.replaceAll("\\[", "").replaceAll("\\]", "");
        sql.append("if not exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[").append(table).append("_EDIT]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)");
        sql.append("BEGIN exec('CREATE PROCEDURE [dbo].[").append(table).append("_EDIT] ").append((CharSequence)parameters).append(" AS UPDATE [").append(table).append("] SET ").append((CharSequence)expressions).append(" WHERE id=@Id')");
        sql.append(" {call ").append(table).append("_EDIT(").append((CharSequence)values).append(")} END");
        sql.append(" else {call ").append(table).append("_EDIT(").append((CharSequence)values).append(")}");
        try (DatabaseOperator operator = new DatabaseOperator();){
            boolean bl = operator.update(sql.toString()) > 0;
            return bl;
        }
    }

    @Override
    public Type getType() {
        return Type.SQLServer;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        Table table = new Table();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement preparedStatement = operator.preparedStatement(SQL, parameters);
            ResultSet resultSet = operator.executeQuery(preparedStatement);
            int cols = resultSet.getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = resultSet.getMetaData().getColumnName(i + 1);
            }
            while (resultSet.next()) {
                Row row = new Row();
                Field fields = new Field();
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = resultSet.getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo field = new FieldInfo();
                    field.append("name", fieldName[i]);
                    field.append("value", fieldValue[i]);
                    field.append("type", field.typeOf(v_field).getTypeName());
                    fields.append(field.getName(), field);
                }
                row.append(fields);
                table.append(row);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return table;
    }
}

