/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.repository;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.DatabaseOperator;
import org.tinystruct.data.component.Field;
import org.tinystruct.data.component.FieldInfo;
import org.tinystruct.data.component.FieldType;
import org.tinystruct.data.component.Row;
import org.tinystruct.data.component.Table;
import org.tinystruct.data.repository.AbstractDataRepository;
import org.tinystruct.data.repository.Type;

public class SQLiteServer
extends AbstractDataRepository {
    @Override
    public boolean append(Field ready_fields, String table) throws ApplicationException {
        FieldInfo currentField;
        String dot = ",";
        StringBuilder expressions = new StringBuilder();
        StringBuilder values = new StringBuilder();
        ArrayList<String> fieldNames = new ArrayList<String>();
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            currentField = ready_fields.get(currentProperty);
            if (currentField.autoIncrement()) continue;
            fieldNames.add(currentProperty);
            if (expressions.length() == 0) {
                expressions.append("[").append(currentField.getColumnName()).append("]");
            } else {
                expressions.append(dot).append("[").append(currentField.getColumnName()).append("]");
            }
            if (values.length() == 0) {
                values.append('?');
                continue;
            }
            values.append(dot).append('?');
        }
        String SQL = "INSERT INTO " + table + " (" + String.valueOf(expressions) + ") VALUES(" + String.valueOf(values) + ")";
        Iterator iterator = fieldNames.iterator();
        DatabaseOperator operator = new DatabaseOperator();
        try {
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            int i = 1;
            while (iterator.hasNext()) {
                currentField = ready_fields.get((String)iterator.next());
                if (currentField.autoIncrement()) continue;
                if ("int".equalsIgnoreCase(currentField.getType().getRealType())) {
                    ps.setInt(i++, currentField.intValue());
                    continue;
                }
                if (currentField.getType() == FieldType.TEXT || currentField.getType() == FieldType.LONGTEXT) {
                    ps.setString(i++, currentField.stringValue());
                    continue;
                }
                if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    ps.setTimestamp(i++, new Timestamp(currentField.dateValue().getTime()));
                    continue;
                }
                if (currentField.getType() == FieldType.BIT) {
                    ps.setBoolean(i++, currentField.booleanValue());
                    continue;
                }
                ps.setObject(i++, currentField.value());
            }
            boolean bl = ps.executeUpdate() > 0;
            operator.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    operator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public boolean update(Field ready_fields, String table) throws ApplicationException {
        FieldInfo currentField;
        String dot = ",";
        StringBuilder expressions = new StringBuilder();
        Object Id2 = null;
        boolean edited = false;
        ArrayList<String> fieldNames = new ArrayList<String>();
        Enumeration _field = ready_fields.keys();
        while (_field.hasMoreElements()) {
            String currentProperty = (String)_field.nextElement();
            currentField = ready_fields.get(currentProperty);
            if ("Id".equalsIgnoreCase(currentField.getName())) {
                Id2 = currentField.value();
                continue;
            }
            if (currentField.value() == null) continue;
            fieldNames.add(currentProperty);
            if (expressions.length() == 0) {
                expressions.append("[").append(currentField.getColumnName()).append("]").append("=?");
                continue;
            }
            expressions.append(dot).append("[").append(currentField.getColumnName()).append("]").append("=?");
        }
        String SQL = "UPDATE " + table + " SET " + String.valueOf(expressions) + " WHERE id=?";
        Iterator iterator = fieldNames.iterator();
        DatabaseOperator operator = new DatabaseOperator();
        try {
            PreparedStatement ps = operator.preparedStatement(SQL, new Object[0]);
            int i = 1;
            while (iterator.hasNext()) {
                currentField = ready_fields.get((String)iterator.next());
                if ("int".equalsIgnoreCase(currentField.getType().getRealType())) {
                    ps.setInt(i++, currentField.intValue());
                    continue;
                }
                if (currentField.getType() == FieldType.TEXT || currentField.getType() == FieldType.LONGTEXT) {
                    ps.setString(i++, currentField.stringValue());
                    continue;
                }
                if (currentField.getType() == FieldType.DATE || currentField.getType() == FieldType.DATETIME) {
                    ps.setTimestamp(i++, new Timestamp(currentField.dateValue().getTime()));
                    continue;
                }
                if (currentField.getType() == FieldType.BIT) {
                    ps.setBoolean(i++, currentField.booleanValue());
                    continue;
                }
                ps.setObject(i++, currentField.value());
            }
            ps.setObject(i, Id2);
            boolean bl = ps.executeUpdate() > 0;
            operator.close();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                try {
                    operator.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SQLException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
    }

    @Override
    public Type getType() {
        return Type.SQLite;
    }

    @Override
    public Table find(String SQL, Object[] parameters) throws ApplicationException {
        Table table = new Table();
        try (DatabaseOperator operator = new DatabaseOperator();){
            PreparedStatement preparedStatement = operator.preparedStatement(SQL, parameters);
            ResultSet resultSet = operator.executeQuery(preparedStatement);
            int cols = resultSet.getMetaData().getColumnCount();
            String[] fieldName = new String[cols];
            Object[] fieldValue = new Object[cols];
            for (int i = 0; i < cols; ++i) {
                fieldName[i] = resultSet.getMetaData().getColumnName(i + 1);
            }
            while (resultSet.next()) {
                Row row = new Row();
                Field fields = new Field();
                for (int i = 0; i < fieldName.length; ++i) {
                    Object v_field = resultSet.getObject(i + 1);
                    fieldValue[i] = v_field == null ? "" : v_field;
                    FieldInfo field = new FieldInfo();
                    field.append("name", fieldName[i]);
                    field.append("value", fieldValue[i]);
                    field.append("type", field.typeOf(v_field).getTypeName());
                    fields.append(field.getName(), field);
                }
                row.append(fields);
                table.append(row);
            }
        }
        catch (Exception e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return table;
    }
}

