/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.tools;

public class CosineSimilarity {
    public static double[] dotProductAndMagnitude(double[] vectorA, double[] vectorB) {
        double dotProduct = 0.0;
        double magnitudeA = 0.0;
        double magnitudeB = 0.0;
        for (int i = 0; i < vectorA.length; ++i) {
            dotProduct += vectorA[i] * vectorB[i];
            magnitudeA += vectorA[i] * vectorA[i];
            magnitudeB += vectorB[i] * vectorB[i];
        }
        magnitudeA = Math.sqrt(magnitudeA);
        magnitudeB = Math.sqrt(magnitudeB);
        return new double[]{dotProduct, magnitudeA, magnitudeB};
    }

    public static double cosineSimilarity(double[] vectorA, double[] vectorB) {
        double[] values = CosineSimilarity.dotProductAndMagnitude(vectorA, vectorB);
        double dotProduct = values[0];
        double magnitudeA = values[1];
        double magnitudeB = values[2];
        if (magnitudeA == 0.0 || magnitudeB == 0.0) {
            return 0.0;
        }
        return dotProduct / (magnitudeA * magnitudeB);
    }
}

