/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.data.tools;

import java.util.Properties;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.ProducerRecord;
import org.apache.kafka.common.serialization.StringSerializer;
import org.tinystruct.AbstractApplication;
import org.tinystruct.system.annotation.Action;

public class KafkaClient
extends AbstractApplication {
    private final KafkaProducer<String, String> producer;
    private static final Logger logger = Logger.getLogger(KafkaClient.class.getName());

    public KafkaClient() {
        Properties properties = new Properties();
        properties.put("bootstrap.servers", "192.168.1.101:9092");
        properties.put("ack", "all");
        properties.put("key.serializer", StringSerializer.class.getName());
        properties.put("value.serializer", StringSerializer.class.getName());
        this.producer = new KafkaProducer(properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Action(value="send")
    public void send(ProducerRecord<String, String> record) {
        Future future = this.producer.send(record);
        try {
            future.get();
        }
        catch (InterruptedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        catch (ExecutionException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
        finally {
            this.producer.close();
        }
    }

    @Override
    public void init() {
    }

    @Override
    public String version() {
        return null;
    }
}

