/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.tinystruct.ApplicationException;
import org.tinystruct.dom.Element;
import org.tinystruct.system.Resources;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class Document
extends DefaultHandler {
    private static final Logger LOG = Logger.getLogger(Document.class.getName());
    private static final String DOCTYPE_CONFIGURATION = "org/tinystruct/application/application-1.0.dtd";
    private static final String XHTML_TRANSITIONAL_DOCTYPE_CONFIGURATION = "org/tinystruct/application/application-1.0.dtd";
    private static final String XHTML_STRICT_DOCTYPE_CONFIGURATION = "org/tinystruct/application/application-1.0.dtd";
    private static final Logger logger = Logger.getLogger(Document.class.getName());
    private static final String HTML5_DOCTYPE = "<!DOCTYPE html>";
    private static final String HTML4_TRANSITIONAL_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\" \"http://www.w3.org/TR/html4/loose.dtd\">";
    private static final String HTML4_STRICT_DOCTYPE = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\" \"http://www.w3.org/TR/html4/strict.dtd\">";
    private static final String XHTML1_TRANSITIONAL_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">";
    private static final String XHTML1_STRICT_DOCTYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    private static final Map<String, String> doctypeMap = new HashMap<String, String>();
    private static final Set<String> voidElements = new HashSet<String>(Arrays.asList("area", "base", "br", "col", "embed", "hr", "img", "input", "link", "meta", "param", "source", "track", "wbr"));
    private final CharArrayWriter contents = new CharArrayWriter();
    private Element rootElement;
    private Element currentElement;
    private URL url = null;
    private DocumentType documentType = DocumentType.XML;
    private boolean preserveWhitespace = false;

    public Document(URL url) {
        this.url = url;
    }

    public Document() {
        this.currentElement = null;
        this.rootElement = null;
    }

    public Document(Element element) {
        this.rootElement = element;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    public boolean load() {
        return this.load(this.url);
    }

    public boolean load(String file) throws ApplicationException {
        boolean bl;
        FileInputStream input = new FileInputStream(file);
        try {
            bl = this.load(input);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException notFoundException) {
                throw new ApplicationException(notFoundException.getMessage(), notFoundException);
            }
            catch (IOException e) {
                throw new ApplicationException(e.getMessage(), e.getCause());
            }
        }
        ((InputStream)input).close();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean load(InputStream input) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(true);
            if (this.documentType != DocumentType.XML) {
                factory.setFeature("http://xml.org/sax/features/namespaces", false);
                factory.setFeature("http://xml.org/sax/features/validation", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(input, (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            LOG.severe("Parser configuration error while attempting to read from the input stream \n'" + String.valueOf(input) + "'");
            LOG.severe(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (SAXException ex) {
            LOG.severe("Parse error while attempting to read from the input stream \n'" + String.valueOf(input) + "'");
            LOG.severe(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (IOException ex) {
            LOG.severe("I/O error while attempting to read from the input stream \n'" + String.valueOf(input) + "'");
            LOG.severe(ex.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        return true;
    }

    public boolean load(URL inputURL) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(inputURL.toString(), (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            LOG.severe("XML config error while attempting to read XML file \n'" + String.valueOf(inputURL) + "'");
            LOG.severe(ex.getMessage());
            return false;
        }
        catch (SAXException ex) {
            LOG.severe("XML parse error while attempting to read XML file \n'" + String.valueOf(inputURL) + "'");
            LOG.severe(ex.getMessage());
            return false;
        }
        catch (IOException ex) {
            LOG.severe("I/O error while attempting to read XML file \n'" + String.valueOf(inputURL) + "'");
            LOG.severe(ex.getMessage());
            return false;
        }
        return true;
    }

    public boolean read(String text) throws ApplicationException {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse((InputStream)new ByteArrayInputStream(text.getBytes()), (DefaultHandler)this);
        }
        catch (ParserConfigurationException ex) {
            LOG.severe("XML config ParserConfigurationException error while attempting to read XML text");
            LOG.severe(ex.getMessage());
            throw new ApplicationException(ex.getMessage(), ex);
        }
        catch (SAXException ex) {
            LOG.severe("XML config SAXException error while attempting to read XML text");
            LOG.severe(ex.getMessage());
            throw new ApplicationException(ex.getMessage(), ex);
        }
        catch (IOException ex) {
            LOG.severe("XML config IOException error while attempting to read XML text");
            LOG.severe(ex.getMessage());
            throw new ApplicationException(ex.getMessage(), ex);
        }
        return true;
    }

    public void setDocumentType(DocumentType type) {
        this.documentType = type;
    }

    public void setPreserveWhitespace(boolean preserve) {
        this.preserveWhitespace = preserve;
    }

    private String getDocTypeDeclaration() {
        switch (this.documentType.ordinal()) {
            case 1: {
                return HTML5_DOCTYPE;
            }
            case 2: {
                return HTML4_TRANSITIONAL_DOCTYPE;
            }
            case 3: {
                return HTML4_STRICT_DOCTYPE;
            }
            case 4: {
                return XHTML1_TRANSITIONAL_DOCTYPE;
            }
            case 5: {
                return XHTML1_STRICT_DOCTYPE;
            }
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>";
    }

    @Override
    public void startElement(String namespaceURI, String localName, String qName, Attributes attrs) throws SAXException {
        try {
            this.contents.reset();
            String name = localName;
            if ("".equals(name)) {
                name = qName;
            }
            if (this.documentType != DocumentType.XML) {
                name = name.toLowerCase();
            }
            if (this.documentType != DocumentType.XML && name.equals("html")) {
                if (this.rootElement == null) {
                    this.currentElement = this.rootElement = new Element(name);
                    if (attrs == null || attrs.getLength() == 0) {
                        switch (this.documentType.ordinal()) {
                            case 4: 
                            case 5: {
                                this.currentElement.setAttribute("xmlns", "http://www.w3.org/1999/xhtml");
                                this.currentElement.setAttribute("xml:lang", "en");
                                this.currentElement.setAttribute("lang", "en");
                                break;
                            }
                            case 1: {
                                this.currentElement.setAttribute("lang", "en");
                                break;
                            }
                            default: {
                                break;
                            }
                        }
                    }
                } else {
                    this.currentElement = this.currentElement.addElement(name);
                }
            } else {
                this.currentElement = this.rootElement == null ? (this.rootElement = new Element(name)) : this.currentElement.addElement(name);
            }
            if (attrs != null) {
                for (int i = 0; i < attrs.getLength(); ++i) {
                    String aName = attrs.getLocalName(i);
                    if ("".equals(aName)) {
                        aName = attrs.getQName(i);
                    }
                    if (this.documentType != DocumentType.XML) {
                        aName = aName.toLowerCase();
                    }
                    this.currentElement.setAttribute(aName, attrs.getValue(i));
                }
            }
        }
        catch (NullPointerException ex) {
            LOG.severe(ex.getMessage());
        }
    }

    @Override
    public void endElement(String namespaceURI, String localName, String qName) {
        if (this.currentElement != null) {
            String content;
            String string = content = this.preserveWhitespace ? this.contents.toString() : this.contents.toString().trim();
            if (this.documentType != DocumentType.XML && (this.currentElement.getName().equalsIgnoreCase("script") || this.currentElement.getName().equalsIgnoreCase("style"))) {
                content = this.contents.toString();
            }
            this.currentElement.setData(content);
            this.contents.reset();
            this.currentElement = this.currentElement.getParent();
        }
    }

    @Override
    public void characters(char[] ch, int start, int length) {
        if (this.documentType != DocumentType.XML && this.currentElement != null && (this.currentElement.getName().equalsIgnoreCase("script") || this.currentElement.getName().equalsIgnoreCase("style"))) {
            this.contents.write(ch, start, length);
        } else {
            String text = new String(ch, start, length);
            if (!this.preserveWhitespace) {
                text = text.replaceAll("\\s+", " ");
            }
            this.contents.write(text.toCharArray(), 0, text.length());
        }
    }

    public Element getRoot() {
        return this.rootElement;
    }

    public void save() throws Exception {
        try (FileOutputStream out = new FileOutputStream(this.url.getPath());){
            this.save(out);
        }
    }

    public void save(OutputStream out) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));
        writer.write(this.getDocTypeDeclaration());
        writer.write(10);
        if (!this.rootElement.getChildNodes().isEmpty()) {
            if (this.documentType != DocumentType.XML) {
                writer.write(this.rootElement.toHtml(this.documentType, voidElements));
            } else {
                writer.write(this.rootElement.toString());
            }
        }
        writer.flush();
    }

    public void saveAsHtml(File file, DocumentType type) throws ApplicationException {
        this.documentType = type;
        try (FileOutputStream out = new FileOutputStream(file);){
            this.save(out);
        }
        catch (IOException e) {
            throw new ApplicationException("Failed to save HTML file: " + file.getPath(), e);
        }
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource source;
        try {
            String path = doctypeMap.get(publicId);
            source = this.getInputSource(path, null);
            if (source != null) {
                path = doctypeMap.get(systemId);
                source = this.getInputSource(path, source);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
        return source;
    }

    private InputSource getInputSource(String path, InputSource source) {
        if (path != null) {
            try (InputStream in = Resources.getResourceAsStream(path);){
                source = new InputSource(in);
            }
            catch (IOException e) {
                LOG.severe(e.getMessage());
            }
        }
        return source;
    }

    public String loadHtml(String html, DocumentType type) throws ApplicationException {
        this.documentType = type;
        try {
            html = this.preprocessHtml(html);
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(false);
            factory.setNamespaceAware(false);
            try {
                factory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            }
            catch (ParserConfigurationException e) {
                logger.log(Level.WARNING, "Could not configure parser features", e);
            }
            SAXParser parser = factory.newSAXParser();
            parser.parse(new InputSource(new StringReader(html)), (DefaultHandler)this);
            return html;
        }
        catch (Exception ex) {
            throw new ApplicationException("Failed to parse HTML: " + ex.getMessage(), ex);
        }
    }

    private String preprocessHtml(String html) {
        String[] tags = ((String)html).split("<|</");
        StringBuilder autoClosedHtml = new StringBuilder();
        LinkedHashSet<String> openTags = new LinkedHashSet<String>();
        for (String tag : tags) {
            boolean isSelfClosing;
            if (tag.trim().isEmpty()) continue;
            int endIndex = tag.indexOf(">");
            if (endIndex == -1) {
                autoClosedHtml.append("<").append(tag);
                continue;
            }
            String tagName = tag.substring(0, endIndex).split("\\s|/>")[0].toLowerCase();
            boolean bl = isSelfClosing = tag.endsWith("/>") || voidElements.contains(tagName);
            if (!(tagName.isEmpty() || tag.startsWith("!") || tag.startsWith("/") || isSelfClosing)) {
                if (tagName.indexOf(32) != -1) {
                    openTags.add(tagName.substring(0, tagName.indexOf(32)));
                } else {
                    openTags.add(tagName);
                }
            } else if (!tagName.isEmpty() && tag.startsWith("/")) {
                openTags.remove(tagName.substring(1));
            }
            autoClosedHtml.append("<").append(tag);
        }
        for (String openTag : openTags) {
            if (voidElements.contains(openTag)) continue;
            autoClosedHtml.append("</").append(openTag).append(">");
        }
        html = autoClosedHtml.toString();
        boolean hasHtmlTag = ((String)html).toLowerCase().contains("<html");
        boolean hasBodyTag = ((String)html).toLowerCase().contains("<body");
        if (!hasHtmlTag) {
            html = "<html>" + (String)html + "</html>";
        }
        if (!hasBodyTag) {
            html = ((String)html).replaceFirst("(<html[^>]*>)", "$1<body>").replaceFirst("(</html>)", "</body>$1");
        }
        StringBuilder processed = new StringBuilder();
        int pos = 0;
        while (pos < ((String)html).length()) {
            int tagStart = ((String)html).indexOf("<", pos);
            if (tagStart == -1) {
                processed.append(((String)html).substring(pos));
                break;
            }
            processed.append((CharSequence)html, pos, tagStart);
            int tagEnd = ((String)html).indexOf(">", tagStart);
            if (tagEnd == -1) {
                processed.append(((String)html).substring(tagStart));
                break;
            }
            String tag = ((String)html).substring(tagStart, tagEnd + 1);
            String tagName = tag.substring(1).split("[ >]")[0].toLowerCase();
            if (voidElements.contains(tagName)) {
                if (!tag.endsWith("/>")) {
                    processed.append(tag.substring(0, tag.length() - 1)).append("/>");
                } else {
                    processed.append(tag);
                }
            } else {
                processed.append(tag);
            }
            pos = tagEnd + 1;
        }
        if (!((String)html).toLowerCase().contains("<!doctype")) {
            html = "<!DOCTYPE html>\n" + String.valueOf(processed);
        }
        return this.escapeTextOnly((String)html);
    }

    private String escapeTextOnly(String html) {
        StringBuilder result = new StringBuilder();
        boolean insideTag = false;
        block5: for (int i = 0; i < html.length(); ++i) {
            char c = html.charAt(i);
            if (c == '<') {
                insideTag = true;
                result.append(c);
                continue;
            }
            if (c == '>') {
                insideTag = false;
                result.append(c);
                continue;
            }
            if (insideTag) {
                result.append(c);
                continue;
            }
            switch (c) {
                case '&': {
                    result.append("&amp;");
                    continue block5;
                }
                case '\"': {
                    result.append("&quot;");
                    continue block5;
                }
                case '\'': {
                    result.append("&apos;");
                    continue block5;
                }
                default: {
                    result.append(c);
                }
            }
        }
        return result.toString();
    }

    static {
        doctypeMap.put("-//development.tinystruct.org//DTD APPLICATION Configuration 2.0//EN", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("http://development.tinystruct.org/dtd/application-1.0.dtd", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("-//W3C//DTD XHTML 1.0 Transitional//EN", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("-//W3C//DTD XHTML 1.0 Strict//EN", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("-//W3C//DTD HTML 4.01 Transitional//EN", "org/tinystruct/application/application-1.0.dtd");
        doctypeMap.put("-//W3C//DTD HTML 4.01//EN", "org/tinystruct/application/application-1.0.dtd");
    }

    public static enum DocumentType {
        XML,
        HTML5,
        HTML4_TRANSITIONAL,
        HTML4_STRICT,
        XHTML1_TRANSITIONAL,
        XHTML1_STRICT;

    }
}

