/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.tinystruct.system.Resources;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DocumentEntityResolver
implements EntityResolver {
    private static final String DOCTYPE_CONFIGURATION = "org/mover/services/application/application-1.0.dtd";
    private static final Map<String, String> doctypeMap = new HashMap<String, String>();

    @Override
    public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
        InputSource source;
        try {
            String path = doctypeMap.get(publicId);
            source = this.getInputSource(path, null);
            if (source != null) {
                path = doctypeMap.get(systemId);
                source = this.getInputSource(path, source);
            }
        }
        catch (Exception e) {
            throw new SAXException(e.toString());
        }
        return source;
    }

    private InputSource getInputSource(String path, InputSource source) {
        if (path != null) {
            try {
                InputStream in = Resources.getResourceAsStream(path);
                source = new InputSource(in);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return source;
    }

    static {
        doctypeMap.put("-//god.mover.com.cn//DTD APPLICATION Configuration 2.0//EN", DOCTYPE_CONFIGURATION);
    }
}

