/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.dom;

public class Escape {
    protected char[] value;
    protected int mappableLimit;
    protected boolean allowControlCharacters;
    protected boolean useCDATA;
    protected final char[] NUL = new char[]{'&', '#', 'x', '0', ';'};
    protected final char[] SOH = new char[]{'&', '#', 'x', '1', ';'};
    protected final char[] STX = new char[]{'&', '#', 'x', '2', ';'};
    protected final char[] ETX = new char[]{'&', '#', 'x', '3', ';'};
    protected final char[] EOT = new char[]{'&', '#', 'x', '4', ';'};
    protected final char[] ENQ = new char[]{'&', '#', 'x', '5', ';'};
    protected final char[] ACK = new char[]{'&', '#', 'x', '6', ';'};
    protected final char[] BEL = new char[]{'&', '#', 'x', '7', ';'};
    protected final char[] BS = new char[]{'&', '#', 'x', '8', ';'};
    protected final char[] TAB = new char[]{'&', '#', 'x', '9', ';'};
    protected final char[] LF = new char[]{'&', '#', 'x', 'A', ';'};
    protected final char[] VT = new char[]{'&', '#', 'x', 'B', ';'};
    protected final char[] FF = new char[]{'&', '#', 'x', 'C', ';'};
    protected final char[] CR = new char[]{'&', '#', 'x', 'D', ';'};
    protected final char[] SO = new char[]{'&', '#', 'x', 'E', ';'};
    protected final char[] SI = new char[]{'&', '#', 'x', 'F', ';'};
    protected final char[] DLE = new char[]{'&', '#', 'x', '1', '0', ';'};
    protected final char[] DC1 = new char[]{'&', '#', 'x', '1', '1', ';'};
    protected final char[] DC2 = new char[]{'&', '#', 'x', '1', '2', ';'};
    protected final char[] DC3 = new char[]{'&', '#', 'x', '1', '3', ';'};
    protected final char[] DC4 = new char[]{'&', '#', 'x', '1', '4', ';'};
    protected final char[] NAK = new char[]{'&', '#', 'x', '1', '5', ';'};
    protected final char[] SYN = new char[]{'&', '#', 'x', '1', '6', ';'};
    protected final char[] ETB = new char[]{'&', '#', 'x', '1', '7', ';'};
    protected final char[] CAN = new char[]{'&', '#', 'x', '1', '8', ';'};
    protected final char[] EM = new char[]{'&', '#', 'x', '1', '9', ';'};
    protected final char[] SUB = new char[]{'&', '#', 'x', '1', 'A', ';'};
    protected final char[] ESC = new char[]{'&', '#', 'x', '1', 'B', ';'};
    protected final char[] FS = new char[]{'&', '#', 'x', '1', 'C', ';'};
    protected final char[] GS = new char[]{'&', '#', 'x', '1', 'D', ';'};
    protected final char[] RS = new char[]{'&', '#', 'x', '1', 'E', ';'};
    protected final char[] US = new char[]{'&', '#', 'x', '1', 'F', ';'};
    protected final char[][] CONTROL_CHARACTERS = new char[][]{this.NUL, this.SOH, this.STX, this.ETX, this.EOT, this.ENQ, this.ACK, this.BEL, this.BS, this.TAB, this.LF, this.VT, this.FF, this.CR, this.SO, this.SI, this.DLE, this.DC1, this.DC2, this.DC3, this.DC4, this.NAK, this.SYN, this.ETB, this.CAN, this.EM, this.SUB, this.ESC, this.FS, this.GS, this.RS, this.US};
    protected final char[] AMP = new char[]{'&', 'a', 'm', 'p', ';'};
    protected final char[] LESS = new char[]{'&', 'l', 't', ';'};
    protected final char[] GREATER = new char[]{'&', 'g', 't', ';'};
    protected final char[] QUOTE = new char[]{'&', 'q', 'u', 'o', 't', ';'};
    protected final char[] LINE_FEED = System.lineSeparator().toCharArray();

    public Escape() {
        this.value = new char[100];
    }

    public void setMappingLimit(int mappingLimit) {
        this.mappableLimit = mappingLimit;
    }

    public void setAllowControlCharacters(boolean allowControlCharacters) {
        this.allowControlCharacters = allowControlCharacters;
    }

    public void setUseCDATA(boolean useCDATA) {
        this.useCDATA = useCDATA;
    }

    public String replaceInvalidCharacters(String input, char[] chars) {
        boolean changed = false;
        int inputLength = input.length();
        this.grow(inputLength);
        int outputPos = 0;
        int inputPos = 0;
        block7: while (inputLength-- > 0) {
            char ch = input.charAt(inputPos++);
            switch (ch) {
                case '\u0000': 
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    if (!this.allowControlCharacters) {
                        outputPos = this.replaceChars(outputPos, chars, inputLength);
                        changed = true;
                        continue block7;
                    }
                    throw new RuntimeException("An invalid XML character (Unicode: 0x" + Integer.toHexString(ch) + ") was found in the element content:" + input);
                }
                case '&': {
                    outputPos = this.replaceChars(outputPos, this.AMP, inputLength);
                    changed = true;
                    continue block7;
                }
                case '\n': {
                    outputPos = this.replaceChars(outputPos, this.LF, inputLength);
                    changed = true;
                    continue block7;
                }
                case '\r': {
                    outputPos = this.replaceChars(outputPos, this.CR, inputLength);
                    changed = true;
                    continue block7;
                }
                case '\t': {
                    outputPos = this.replaceChars(outputPos, this.TAB, inputLength);
                    changed = true;
                    continue block7;
                }
            }
            this.value[outputPos++] = ch;
        }
        return changed ? new String(this.value, 0, outputPos) : input;
    }

    public String convert(String input) {
        boolean changed = false;
        int inputLength = input.length();
        this.grow(inputLength);
        int outputPos = 0;
        int inputPos = 0;
        block9: while (inputLength-- > 0) {
            char ch = input.charAt(inputPos++);
            switch (ch) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    if (this.allowControlCharacters) {
                        outputPos = this.replaceChars(outputPos, this.CONTROL_CHARACTERS[ch], inputLength);
                        changed = true;
                        continue block9;
                    }
                    throw new RuntimeException("An invalid XML character (Unicode: 0x" + Integer.toHexString(ch) + ") was found in the element content:" + input);
                }
                case '&': {
                    outputPos = this.replaceChars(outputPos, this.AMP, inputLength);
                    changed = true;
                    continue block9;
                }
                case '<': {
                    outputPos = this.replaceChars(outputPos, this.LESS, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\"': {
                    outputPos = this.replaceChars(outputPos, this.QUOTE, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\n': {
                    outputPos = this.replaceChars(outputPos, this.LF, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\r': {
                    outputPos = this.replaceChars(outputPos, this.CR, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\t': {
                    outputPos = this.replaceChars(outputPos, this.TAB, inputLength);
                    changed = true;
                    continue block9;
                }
            }
            if (ch <= this.mappableLimit) {
                this.value[outputPos++] = ch;
                continue;
            }
            outputPos = this.replaceChars(outputPos, ("&#x" + Integer.toHexString(ch) + ";").toCharArray(), inputLength);
            changed = true;
        }
        return changed ? new String(this.value, 0, outputPos) : input;
    }

    public String convertText(String input) {
        boolean changed = false;
        boolean cdataCloseBracket = false;
        int inputLength = input.length();
        this.grow(inputLength);
        int outputPos = 0;
        int inputPos = 0;
        block9: while (inputLength-- > 0) {
            char ch = input.charAt(inputPos++);
            switch (ch) {
                case '\u0001': 
                case '\u0002': 
                case '\u0003': 
                case '\u0004': 
                case '\u0005': 
                case '\u0006': 
                case '\u0007': 
                case '\b': 
                case '\u000b': 
                case '\f': 
                case '\u000e': 
                case '\u000f': 
                case '\u0010': 
                case '\u0011': 
                case '\u0012': 
                case '\u0013': 
                case '\u0014': 
                case '\u0015': 
                case '\u0016': 
                case '\u0017': 
                case '\u0018': 
                case '\u0019': 
                case '\u001a': 
                case '\u001b': 
                case '\u001c': 
                case '\u001d': 
                case '\u001e': 
                case '\u001f': {
                    if (this.allowControlCharacters) {
                        outputPos = this.replaceChars(outputPos, this.CONTROL_CHARACTERS[ch], inputLength);
                        changed = true;
                        continue block9;
                    }
                    throw new RuntimeException("An invalid XML character (Unicode: 0x" + Integer.toHexString(ch) + ") was found in the element content:" + input);
                }
                case '&': {
                    outputPos = this.replaceChars(outputPos, this.AMP, inputLength);
                    changed = true;
                    continue block9;
                }
                case '<': {
                    outputPos = this.replaceChars(outputPos, this.LESS, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\"': {
                    outputPos = this.replaceChars(outputPos, this.QUOTE, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\n': {
                    outputPos = this.replaceChars(outputPos, this.LINE_FEED, inputLength);
                    changed = true;
                    continue block9;
                }
                case '\r': {
                    outputPos = this.replaceChars(outputPos, this.CR, inputLength);
                    changed = true;
                    continue block9;
                }
                case '>': {
                    if (inputPos < 3 || input.charAt(inputPos - 2) != ']' || input.charAt(inputPos - 3) != ']') break;
                    outputPos = this.replaceChars(outputPos, this.GREATER, inputLength);
                    cdataCloseBracket = true;
                    changed = true;
                    continue block9;
                }
            }
            if (ch <= this.mappableLimit) {
                this.value[outputPos++] = ch;
                continue;
            }
            outputPos = this.replaceChars(outputPos, ("&#x" + Integer.toHexString(ch) + ";").toCharArray(), inputLength);
            changed = true;
        }
        return changed ? (!this.useCDATA || cdataCloseBracket ? new String(this.value, 0, outputPos) : "<![CDATA[" + input + "]]>") : input;
    }

    public String convertLines(String input) {
        boolean changed = false;
        int inputLength = input.length();
        this.grow(inputLength);
        int outputPos = 0;
        int inputPos = 0;
        block3: while (inputLength-- > 0) {
            char ch = input.charAt(inputPos++);
            switch (ch) {
                case '\n': {
                    outputPos = this.replaceChars(outputPos, this.LINE_FEED, inputLength);
                    changed = true;
                    continue block3;
                }
            }
            this.value[outputPos++] = ch;
        }
        return changed ? new String(this.value, 0, outputPos) : input;
    }

    protected int replaceChars(int pos, char[] replacement, int inputLength) {
        int rlen = replacement.length;
        int newPos = pos + rlen;
        this.grow(newPos + inputLength);
        System.arraycopy(replacement, 0, this.value, pos, rlen);
        return newPos;
    }

    protected void grow(int newSize) {
        int vlen = this.value.length;
        if (vlen < newSize) {
            char[] newValue = new char[newSize + newSize / 2];
            System.arraycopy(this.value, 0, newValue, 0, vlen);
            this.value = newValue;
        }
    }
}

