/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationContext;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Context;
import org.tinystruct.handler.Reforward;
import org.tinystruct.http.Header;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseStatus;
import org.tinystruct.http.Session;
import org.tinystruct.http.servlet.RequestBuilder;
import org.tinystruct.http.servlet.ResponseBuilder;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Bootstrap;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Language;
import org.tinystruct.system.Settings;
import org.tinystruct.system.util.StringUtilities;

public class DefaultHandler
extends HttpServlet
implements Bootstrap,
Filter {
    private static final Logger logger = Logger.getLogger(DefaultHandler.class.getName());
    private static final long serialVersionUID = 0L;
    private String charsetName;
    private Configuration<String> settings;
    private String path;

    public void init(ServletConfig config) {
        this.path = config.getServletContext().getRealPath("");
        try {
            this.start();
        }
        catch (ApplicationException e) {
            logger.severe(e.getMessage());
        }
        logger.info("Initialized servlet config and starting...");
    }

    public void init(FilterConfig config) throws ServletException {
        this.path = config.getServletContext().getRealPath("");
        try {
            this.start();
        }
        catch (ApplicationException e) {
            logger.severe(e.getMessage());
        }
        logger.info("Initialized filter config and starting...");
    }

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException {
        request.setCharacterEncoding(this.charsetName);
        response.setContentType("text/html;charset=" + this.charsetName);
        response.setCharacterEncoding(this.charsetName);
        response.setHeader("Pragma", "No-cache");
        response.setHeader("Cache-Control", "No-cache");
        response.setDateHeader("Expires", 0L);
        ApplicationContext context = new ApplicationContext();
        RequestBuilder _request = new RequestBuilder(request, this.isSSL());
        ResponseBuilder _response = new ResponseBuilder(response);
        try {
            String[] parameterNames;
            String name;
            context.setId(_request.getSession().getId());
            context.setAttribute("HTTP_REQUEST", _request);
            context.setAttribute("HTTP_RESPONSE", _response);
            context.setAttribute("HTTP_SCHEME", request.getScheme());
            context.setAttribute("HTTP_SERVER", request.getServerName());
            context.setAttribute("HTTP_PROTOCOL", this.getProtocol(request));
            String lang = _request.getParameter("lang");
            if (lang != null && !lang.trim().isEmpty() && Language.support(name = lang.replace('-', '_')) && !lang.equalsIgnoreCase(this.settings.get("language"))) {
                context.setAttribute("language", name);
            }
            String url_prefix = "/";
            if (this.settings.get("default.url_rewrite") != null && !"enabled".equalsIgnoreCase(this.settings.get("default.url_rewrite"))) {
                url_prefix = "/?q=";
            }
            context.setAttribute("HTTP_HOST", this.getHost(request) + url_prefix);
            context.setAttribute("METHOD", request.getMethod());
            for (String parameter : parameterNames = _request.parameterNames()) {
                if (!parameter.startsWith("--")) continue;
                context.setAttribute(parameter, request.getParameter(parameter));
            }
            String query = _request.getParameter("q");
            if (query != null) {
                this.handleRequest(query, context, _response);
            } else {
                this.handleDefaultPage(context, _response);
            }
        }
        catch (ApplicationException e) {
            try {
                this.handleApplicationException(_request, _response, e);
            }
            catch (ApplicationException ex) {
                logger.log(Level.SEVERE, ex.getMessage(), ex);
            }
        }
    }

    private void handleRequest(String query, Context context, Response<HttpServletResponse, ServletOutputStream> response) throws IOException, ApplicationException {
        Object message = ApplicationManager.call(query = StringUtilities.htmlSpecialChars(query), context);
        if (message != null) {
            if (message instanceof byte[]) {
                byte[] bytes = (byte[])message;
                response.addHeader(Header.CONTENT_LENGTH.name(), String.valueOf(bytes.length));
                response.get().write(bytes);
            } else {
                try (BufferedWriter bufferedWriter = this.getWriter((OutputStream)response.get());){
                    bufferedWriter.write(String.valueOf(message));
                }
            }
        } else {
            try (BufferedWriter bufferedWriter = this.getWriter((OutputStream)response.get());){
                bufferedWriter.write("No response retrieved!");
            }
        }
    }

    private void handleDefaultPage(Context context, Response<HttpServletResponse, ServletOutputStream> response) throws IOException, ApplicationException {
        try (BufferedWriter bufferedWriter = this.getWriter((OutputStream)response.get());){
            bufferedWriter.write(String.valueOf(ApplicationManager.call(this.settings.getOrDefault("default.home.page", "say/Praise the Lord."), context)));
        }
    }

    private void handleApplicationException(Request<HttpServletRequest, ServletInputStream> request, Response<HttpServletResponse, ServletOutputStream> response, ApplicationException e) throws ApplicationException {
        response.setStatus(ResponseStatus.valueOf(e.getStatus()));
        Session session = request.getSession();
        session.setAttribute("error", e);
        if (!Boolean.parseBoolean(this.settings.get("default.error.process"))) {
            String defaultErrorPage = this.settings.get("default.error.page");
            Reforward forward = new Reforward(request, response);
            forward.setDefault((String)(defaultErrorPage.trim().isEmpty() ? "/?q=error" : "/?q=" + defaultErrorPage));
            forward.forward();
        }
    }

    @Override
    public void start() throws ApplicationException {
        this.settings = new Settings();
        this.charsetName = this.settings.getOrDefault("default.file.encoding", Charset.defaultCharset().name());
        this.settings.set("language", "zh_CN");
        this.settings.setIfAbsent("system.directory", this.path);
    }

    private boolean isSSL() {
        String sslEnabled = this.settings.get("ssl.enabled");
        return Boolean.parseBoolean(sslEnabled);
    }

    private String getProtocol(HttpServletRequest request) {
        return this.isSSL() ? "https://" : "http://";
    }

    private String getHost(HttpServletRequest request) {
        int serverPort = request.getServerPort();
        String defaultHostName = request.getServerName();
        String protocol = this.getProtocol(request);
        if (serverPort == 80) {
            return protocol + defaultHostName;
        }
        return protocol + defaultHostName + ":" + serverPort;
    }

    private BufferedWriter getWriter(OutputStream out) {
        return new BufferedWriter(new OutputStreamWriter(out, Charset.forName(this.charsetName)));
    }

    @Override
    public void stop() {
        System.out.println("Stopping...");
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)request;
        HttpServletResponse resp = (HttpServletResponse)response;
        long now = System.currentTimeMillis();
        resp.addHeader("Cache-Control", "public, max-age=86400, must-revalidate");
        resp.setDateHeader("Expires", now + 86400000L);
        String uri = req.getRequestURI().replaceAll("^/+", "");
        if (uri.length() > 1) {
            if (uri.indexOf(47) != -1) {
                uri = uri.substring(0, uri.indexOf("/"));
            }
            uri = uri.replace("%2e", ".");
            uri = uri.replace("%2f", "/");
            File resource = new File(uri = uri.replace("%5c", "/"));
            if (resource.exists()) {
                chain.doFilter(request, response);
            } else {
                this.service(req, resp);
            }
        } else {
            this.service(req, resp);
        }
    }

    public void destroy() {
        this.stop();
    }

    @Override
    public void run() {
    }
}

