/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtException;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Objects;
import org.tinystruct.ApplicationContext;
import org.tinystruct.ApplicationException;
import org.tinystruct.application.Context;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.CookieImpl;
import org.tinystruct.http.Header;
import org.tinystruct.http.Request;
import org.tinystruct.http.RequestBuilder;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseBuilder;
import org.tinystruct.http.ResponseHeaders;
import org.tinystruct.http.ResponseStatus;
import org.tinystruct.http.security.JWTManager;
import org.tinystruct.system.ApplicationManager;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Language;
import org.tinystruct.system.util.StringUtilities;

public class HttpRequestHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final Configuration<String> configuration;

    public HttpRequestHandler(Configuration<String> configuration) {
        this.configuration = configuration;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest msg) {
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)msg);
        boolean ssl = Boolean.parseBoolean(this.configuration.getOrDefault("ssl.enabled", "false"));
        RequestBuilder request = new RequestBuilder(msg, ssl);
        ApplicationContext context = new ApplicationContext();
        context.setId(request.getSession().getId());
        this.service(ctx, request, context, keepAlive);
    }

    private void service(ChannelHandlerContext ctx, Request<FullHttpRequest, Object> request, Context context, boolean keepAlive) {
        ByteBuf resp;
        Object message;
        String[] parameterNames;
        if (!this.authenticateRequest(request, context)) {
            this.sendErrorResponse(ctx, HttpResponseStatus.UNAUTHORIZED, "Invalid or expired token.");
            return;
        }
        for (String parameter : parameterNames = request.parameterNames()) {
            if (!parameter.startsWith("--")) continue;
            context.setAttribute(parameter, request.getParameter(parameter));
        }
        HttpResponseStatus status = HttpResponseStatus.OK;
        ResponseBuilder response = new ResponseBuilder((FullHttpResponse)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status));
        String host = request.headers().get(Header.HOST).toString();
        try {
            String hostName;
            String name;
            String lang = request.getParameter("lang");
            if (lang != null && !lang.trim().isEmpty() && Language.support(name = lang.replace('-', '_')) && !lang.equalsIgnoreCase(this.configuration.get("language"))) {
                context.setAttribute("language", name);
            }
            String url_prefix = "/";
            if (this.configuration.get("default.url_rewrite") != null && !"enabled".equalsIgnoreCase(this.configuration.get("default.url_rewrite"))) {
                url_prefix = "/?q=";
            }
            if ((hostName = this.configuration.get("default.hostname")) != null) {
                if (hostName.length() <= 3) {
                    hostName = host;
                }
            } else {
                hostName = host;
            }
            String http_protocol = "http://";
            if (request.isSecure()) {
                http_protocol = "https://";
            }
            context.setAttribute("HTTP_HOST", http_protocol + hostName + url_prefix);
            context.setAttribute("METHOD", (Object)request.method());
            context.setAttribute("HTTP_REQUEST", request);
            context.setAttribute("HTTP_RESPONSE", response);
            Object query = request.query();
            if (query != null && ((String)query).length() > 1) {
                message = ApplicationManager.call((String)(query = StringUtilities.htmlSpecialChars((String)query)), context);
                if (null == message) {
                    message = "No response retrieved!";
                } else if (message instanceof Response) {
                    ChannelFuture future = ctx.writeAndFlush(((Response)message).get());
                    if (!keepAlive) {
                        future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
                    }
                    return;
                }
            } else {
                message = ApplicationManager.call(this.configuration.getOrDefault("default.home.page", "say/Praise the Lord."), context);
            }
        }
        catch (ApplicationException e) {
            StackTraceElement[] trace = e.getStackTrace();
            message = e.getMessage();
            if (trace.length > 0 && null != e.getCause()) {
                message = e.getCause().toString();
            }
            response.setStatus(Objects.requireNonNull(ResponseStatus.valueOf(e.getStatus())));
        }
        try {
            resp = message instanceof byte[] ? Unpooled.copiedBuffer((byte[])((byte[])message)) : Unpooled.copiedBuffer((CharSequence)message.toString(), (Charset)CharsetUtil.UTF_8);
        }
        catch (Exception e) {
            resp = Unpooled.copiedBuffer((CharSequence)e.getMessage(), (Charset)CharsetUtil.UTF_8);
        }
        FullHttpResponse replacement = response.get().replace(resp);
        response = new ResponseBuilder(replacement);
        ResponseHeaders responseHeaders = new ResponseHeaders(response);
        boolean sessionCookieExists = false;
        for (Cookie cookie : request.cookies()) {
            if (!cookie.name().equalsIgnoreCase("JSESSIONID")) continue;
            sessionCookieExists = true;
            break;
        }
        if (!sessionCookieExists) {
            CookieImpl cookie = new CookieImpl("JSESSIONID");
            if (host.contains(":")) {
                cookie.setDomain(host.substring(0, host.indexOf(":")));
            }
            cookie.setValue(context.getId());
            cookie.setHttpOnly(true);
            cookie.setPath("/");
            cookie.setMaxAge(-1L);
            responseHeaders.add(Header.SET_COOKIE.set(cookie));
        }
        if (!responseHeaders.contains(Header.CONTENT_TYPE)) {
            response.setContentType("text/html; charset=UTF-8");
        }
        switch (response.status()) {
            case TEMPORARY_REDIRECT: 
            case MOVED_PERMANENTLY: 
            case PERMANENT_REDIRECT: {
                keepAlive = false;
                break;
            }
            default: {
                responseHeaders.add(Header.CONTENT_LENGTH.setInt(resp.readableBytes()));
            }
        }
        ChannelFuture future = ctx.writeAndFlush((Object)response.get());
        if (!keepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private boolean authenticateRequest(Request<FullHttpRequest, Object> request, Context context) {
        String authHeader;
        Object authorization = request.headers().get(Header.AUTHORIZATION);
        if (authorization != null && (authHeader = authorization.toString()) != null && authHeader.startsWith("Bearer ")) {
            String token = authHeader.substring(7);
            JWTManager jwtManager = new JWTManager();
            jwtManager.withSecret(this.configuration.get("jwt.secret"));
            try {
                Jws<Claims> claims = jwtManager.parseToken(token);
                context.setAttribute("CLAIMS", claims);
                return true;
            }
            catch (JwtException e) {
                return false;
            }
        }
        return true;
    }

    private void sendErrorResponse(ChannelHandlerContext ctx, HttpResponseStatus status, String message) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)message, (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)content.readableBytes());
        ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        ctx.flush();
    }

    static {
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = null;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskAttribute.baseDirectory = null;
    }
}

