/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelProgressiveFuture;
import io.netty.channel.ChannelProgressiveFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpChunkedInput;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpUtil;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.SystemPropertyUtil;
import jakarta.activation.MimetypesFileTypeMap;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.net.URLDecoder;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Objects;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;

public class HttpStaticFileHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    public static final String HTTP_DATE_FORMAT = "EEE, dd MMM yyyy HH:mm:ss zzz";
    public static final String HTTP_DATE_GMT_TIMEZONE = "GMT";
    public static final int HTTP_CACHE_SECONDS = 60;
    private static final Pattern INSECURE_URI = Pattern.compile(".*[<>&\"].*");
    private FullHttpRequest request;
    private static final Logger logger = Logger.getLogger(HttpStaticFileHandler.class.getName());

    private static String sanitizeUri(String uri) {
        if ((uri = URLDecoder.decode(uri, StandardCharsets.UTF_8)).isEmpty() || uri.charAt(0) != '/') {
            return null;
        }
        if (uri.length() > 255) {
            throw new IllegalArgumentException("Input too long");
        }
        uri = uri.replace('/', File.separatorChar);
        if ((uri = uri.replaceAll("\\.\\.", "")).contains(File.separator + ".") || uri.contains("." + File.separator) || uri.charAt(0) == '.' || uri.charAt(uri.length() - 1) == '.' || INSECURE_URI.matcher(uri).matches()) {
            return null;
        }
        return SystemPropertyUtil.get((String)"user.dir") + File.separator + uri;
    }

    private static void setDateHeader(FullHttpResponse response) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
    }

    private static void setDateAndCacheHeaders(HttpResponse response, File fileToCache) {
        SimpleDateFormat dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US);
        dateFormatter.setTimeZone(TimeZone.getTimeZone(HTTP_DATE_GMT_TIMEZONE));
        GregorianCalendar time = new GregorianCalendar();
        response.headers().set((CharSequence)HttpHeaderNames.DATE, (Object)dateFormatter.format(time.getTime()));
        ((Calendar)time).add(13, 60);
        response.headers().set((CharSequence)HttpHeaderNames.EXPIRES, (Object)dateFormatter.format(time.getTime()));
        response.headers().set((CharSequence)HttpHeaderNames.CACHE_CONTROL, (Object)"private, max-age=60");
        response.headers().set((CharSequence)HttpHeaderNames.LAST_MODIFIED, (Object)dateFormatter.format(new Date(fileToCache.lastModified())));
    }

    private static void setContentTypeHeader(HttpResponse response, File file) {
        String contentType = null;
        try {
            MimetypesFileTypeMap mimeTypesMap = new MimetypesFileTypeMap(HttpStaticFileHandler.class.getResourceAsStream("/META-INF/mime.types"));
            contentType = mimeTypesMap.getContentType(file);
        }
        catch (Exception mimeTypesMap) {
            // empty catch block
        }
        if (contentType == null || contentType.equalsIgnoreCase("application/octet-stream")) {
            try {
                String name = file.getName().substring(0, file.getName().indexOf(".")) + file.getName().substring(file.getName().lastIndexOf("."));
                contentType = Files.probeContentType(Path.of(name, new String[0]));
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (contentType == null) {
            contentType = "application/octet-stream";
        }
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)contentType);
    }

    public void channelRead0(ChannelHandlerContext ctx, FullHttpRequest request) throws Exception {
        ChannelFuture lastContentFuture;
        ChannelFuture sendFileFuture;
        long fileLastModifiedSeconds;
        SimpleDateFormat dateFormatter;
        Date ifModifiedSinceDate;
        long ifModifiedSinceDateSeconds;
        File file;
        this.request = request;
        if (!request.decoderResult().isSuccess()) {
            request.retain();
            ctx.fireChannelRead((Object)request);
            return;
        }
        if (!HttpMethod.GET.equals((Object)request.method())) {
            request.retain();
            ctx.fireChannelRead((Object)request);
            return;
        }
        String uri = request.uri();
        String path = HttpStaticFileHandler.sanitizeUri(uri);
        if (path == null) {
            request.retain();
            ctx.fireChannelRead((Object)request);
            return;
        }
        String filepath = path;
        if (path.contains("?")) {
            filepath = path.substring(0, path.indexOf("?"));
        }
        if ((file = new File(filepath)).isHidden() || !file.exists()) {
            if (filepath.endsWith("/favicon.ico")) {
                try (InputStream stream = Objects.requireNonNull(((Object)((Object)this)).getClass().getResource("/favicon.ico")).openStream();){
                    block35: {
                        ReadableByteChannel channel = Channels.newChannel(stream);
                        try {
                            ByteBuffer buffer = ByteBuffer.allocate(stream.available());
                            channel.read(buffer);
                            buffer.rewind();
                            ByteBuf buf = Unpooled.wrappedBuffer((ByteBuffer)buffer);
                            DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, buf);
                            response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"image/x-icon");
                            response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, buf.readableBytes());
                            this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
                            if (channel == null) break block35;
                        }
                        catch (Throwable buffer) {
                            if (channel != null) {
                                try {
                                    channel.close();
                                }
                                catch (Throwable buf) {
                                    buffer.addSuppressed(buf);
                                }
                            }
                            throw buffer;
                        }
                        channel.close();
                    }
                    return;
                }
                catch (Exception e) {
                    this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
                    return;
                }
            }
            request.retain();
            ctx.fireChannelRead((Object)request);
            return;
        }
        if (!file.isFile()) {
            request.retain();
            ctx.fireChannelRead((Object)request);
            return;
        }
        String ifModifiedSince = request.headers().get((CharSequence)HttpHeaderNames.IF_MODIFIED_SINCE);
        if (ifModifiedSince != null && !ifModifiedSince.isEmpty() && (ifModifiedSinceDateSeconds = (ifModifiedSinceDate = (dateFormatter = new SimpleDateFormat(HTTP_DATE_FORMAT, Locale.US)).parse(ifModifiedSince)).getTime() / 1000L) == (fileLastModifiedSeconds = file.lastModified() / 1000L)) {
            this.sendNotModified(ctx);
            return;
        }
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        try (RandomAccessFile raf = new RandomAccessFile(file, "r");){
            long fileLength = raf.length();
            DefaultHttpResponse response = new DefaultHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK);
            HttpUtil.setContentLength((HttpMessage)response, (long)fileLength);
            HttpStaticFileHandler.setContentTypeHeader((HttpResponse)response, file);
            HttpStaticFileHandler.setDateAndCacheHeaders((HttpResponse)response, file);
            if (!keepAlive) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
            } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
                response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            }
            ctx.write((Object)response);
            if (ctx.pipeline().get(SslHandler.class) == null) {
                sendFileFuture = ctx.write((Object)new DefaultFileRegion(raf.getChannel(), 0L, fileLength), (ChannelPromise)ctx.newProgressivePromise());
                lastContentFuture = ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
            } else {
                lastContentFuture = sendFileFuture = ctx.writeAndFlush((Object)new HttpChunkedInput((ChunkedInput)new ChunkedFile(raf, 0L, fileLength, 8192)), (ChannelPromise)ctx.newProgressivePromise());
            }
        }
        catch (FileNotFoundException ignore) {
            this.sendError(ctx, HttpResponseStatus.NOT_FOUND);
            return;
        }
        sendFileFuture.addListener((GenericFutureListener)new ChannelProgressiveFutureListener(){

            public void operationProgressed(ChannelProgressiveFuture future, long progress, long total) {
                if (total < 0L) {
                    System.err.println(String.valueOf(future.channel()) + " Transfer progress: " + progress);
                } else {
                    System.err.println(String.valueOf(future.channel()) + " Transfer progress: " + progress + " / " + total);
                }
            }

            public void operationComplete(ChannelProgressiveFuture future) {
                System.err.println(String.valueOf(future.channel()) + " Transfer complete.");
            }
        });
        if (!keepAlive) {
            lastContentFuture.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        logger.log(Level.SEVERE, "Exception caught!", cause);
        if (ctx.channel().isActive()) {
            this.sendError(ctx, HttpResponseStatus.INTERNAL_SERVER_ERROR);
        }
    }

    private void sendError(ChannelHandlerContext ctx, HttpResponseStatus status) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, Unpooled.copiedBuffer((CharSequence)("Failure: " + String.valueOf(status) + "\r\n"), (Charset)CharsetUtil.UTF_8));
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
    }

    private void sendNotModified(ChannelHandlerContext ctx) {
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.NOT_MODIFIED, Unpooled.EMPTY_BUFFER);
        HttpStaticFileHandler.setDateHeader((FullHttpResponse)response);
        this.sendAndCleanupConnection(ctx, (FullHttpResponse)response);
    }

    private void sendAndCleanupConnection(ChannelHandlerContext ctx, FullHttpResponse response) {
        FullHttpRequest request = this.request;
        boolean keepAlive = HttpUtil.isKeepAlive((HttpMessage)request);
        HttpUtil.setContentLength((HttpMessage)response, (long)response.content().readableBytes());
        if (!keepAlive) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.CLOSE);
        } else if (request.protocolVersion().equals((Object)HttpVersion.HTTP_1_0)) {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
        }
        ChannelFuture flushPromise = ctx.writeAndFlush((Object)response);
        if (!keepAlive) {
            flushPromise.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

