/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.mqtt.MqttConnAckMessage;
import io.netty.handler.codec.mqtt.MqttConnectMessage;
import io.netty.handler.codec.mqtt.MqttConnectReturnCode;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageBuilders;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.util.CharsetUtil;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MQTTServerHandler
extends SimpleChannelInboundHandler<MqttMessage> {
    public static final MQTTServerHandler INSTANCE = new MQTTServerHandler();
    private static final Logger logger = Logger.getLogger(MQTTServerHandler.class.getName());

    protected void channelRead0(ChannelHandlerContext ctx, MqttMessage message) throws Exception {
        if (message instanceof MqttConnectMessage) {
            this.handleConnect(ctx, (MqttConnectMessage)message);
        } else if (message instanceof MqttPublishMessage) {
            this.handlePublish(ctx, (MqttPublishMessage)message);
        } else if (message instanceof MqttSubscribeMessage) {
            this.handleSubscribe(ctx, (MqttSubscribeMessage)message);
        }
    }

    private void handleConnect(ChannelHandlerContext ctx, MqttConnectMessage connectMessage) {
        MqttConnAckMessage connAckMessage = MqttMessageBuilders.connAck().returnCode(MqttConnectReturnCode.CONNECTION_ACCEPTED).build();
        ctx.writeAndFlush((Object)connAckMessage);
    }

    private void handlePublish(ChannelHandlerContext ctx, MqttPublishMessage publishMessage) {
        String topic = publishMessage.variableHeader().topicName();
        ByteBuf payload = publishMessage.payload();
        String message = payload.toString(CharsetUtil.UTF_8);
        System.out.println("Received message on topic: " + topic);
        System.out.println("Message: " + message);
        this.persist(topic, message);
        MqttMessage mqttAck = MqttMessageBuilders.pubAck().packetId(publishMessage.variableHeader().packetId()).build();
        ctx.writeAndFlush((Object)mqttAck);
    }

    private void handleSubscribe(ChannelHandlerContext ctx, MqttSubscribeMessage subscribeMessage) {
        MqttSubAckMessage subAckMessage = MqttMessageBuilders.subAck().addGrantedQos(MqttQoS.AT_MOST_ONCE).packetId(subscribeMessage.variableHeader().messageId()).build();
        ctx.writeAndFlush((Object)subAckMessage);
    }

    protected void persist(String topic, String message) {
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) throws Exception {
        logger.log(Level.SEVERE, "Exception caught!", e);
        ctx.close();
    }
}

