/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLException;
import org.tinystruct.handler.ProxyHandler;
import org.tinystruct.handler.ProxyOutboundHandler;

public abstract class ProxyInboundHandler
extends ChannelInboundHandlerAdapter
implements ProxyHandler {
    private static final Logger logger = Logger.getLogger(ProxyInboundHandler.class.getName());
    private Channel outboundChannel;
    String remoteHost = "localhost";
    final int remotePort;

    public ProxyInboundHandler(String remoteHost, int remotePort) {
        this.remoteHost = remoteHost;
        this.remotePort = remotePort;
    }

    public ProxyInboundHandler(int remotePort) {
        this.remotePort = remotePort;
    }

    public void channelActive(ChannelHandlerContext ctx) {
        final Channel inboundChannel = ctx.channel();
        Bootstrap b = new Bootstrap();
        ((Bootstrap)((Bootstrap)((Bootstrap)b.group((EventLoopGroup)inboundChannel.eventLoop())).channel(ctx.channel().getClass())).handler((ChannelHandler)new ProxyOutboundHandler(inboundChannel))).option(ChannelOption.AUTO_READ, (Object)false);
        ChannelFuture f = b.connect(this.remoteHost, this.remotePort);
        SslContext sslCtx = null;
        if (this.remotePort == 443) {
            try {
                sslCtx = SslContextBuilder.forClient().build();
            }
            catch (SSLException e) {
                logger.log(Level.SEVERE, e.getMessage(), e);
            }
        }
        this.outboundChannel = f.channel();
        if (sslCtx != null) {
            this.outboundChannel.pipeline().addLast(new ChannelHandler[]{sslCtx.newHandler(this.outboundChannel.alloc())});
        }
        this.outboundChannel.pipeline().addLast(this.initCodecs());
        f.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                if (future.isSuccess()) {
                    inboundChannel.read();
                } else {
                    inboundChannel.close();
                }
            }
        });
    }

    public void channelRead(final ChannelHandlerContext ctx, Object msg) {
        logger.log(Level.INFO, msg.getClass().getName());
        if (this.outboundChannel.isActive() && this.outboundChannel.isWritable()) {
            this.outboundChannel.writeAndFlush(msg).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    if (future.isSuccess()) {
                        ctx.channel().read();
                    } else {
                        future.channel().close();
                    }
                }
            });
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (this.outboundChannel != null) {
            ProxyInboundHandler.closeOnFlush(this.outboundChannel);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable e) {
        logger.log(Level.SEVERE, "Exception caught!", e);
        ProxyInboundHandler.closeOnFlush(ctx.channel());
    }

    @Override
    public void addCodec(ChannelPipeline pipeline, ChannelHandler ... handler) {
        pipeline.addLast(handler);
    }

    static void closeOnFlush(Channel ch) {
        if (ch.isActive()) {
            ch.writeAndFlush((Object)Unpooled.EMPTY_BUFFER).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }
}

