/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.handler;

import java.io.IOException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.tinystruct.ApplicationException;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Request;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseHeaders;

public class Reforward {
    private final Response response;
    private String fromURL = "";
    private final String currentURL;

    public Reforward(Request request, Response response) throws ApplicationException {
        this.response = response;
        this.currentURL = request.query() != null ? request.uri() + "?" + request.query() : request.uri();
        Headers headers = request.headers();
        if (request.getParameter("from") != null && !request.getParameter("from").trim().isEmpty()) {
            this.setDefault(request.getParameter("from"));
        } else {
            this.fromURL = headers.get(Header.REFERER) != null && headers.get(Header.REFERER).toString().startsWith((String)(request.isSecure() ? "https" : "http://" + String.valueOf(request.headers().get(Header.SERVER)))) ? (request.isSecure() ? headers.get(Header.REFERER).toString().replaceAll("http://", "https://") : headers.get(Header.REFERER).toString()) : "/";
        }
        Cookie[] cookies = request.cookies();
        ResponseHeaders responseHeaders = new ResponseHeaders(response);
        for (Cookie cookie : cookies) {
            responseHeaders.add(Header.SET_COOKIE.set(cookie));
        }
    }

    public void setDefault(String url) throws ApplicationException {
        this.fromURL = url.contains("%3A") ? URLDecoder.decode(url, StandardCharsets.UTF_8) : url;
    }

    public void match(String action, String fromURL) {
        if ("".equals(action)) {
            this.fromURL = fromURL;
        }
    }

    public Response forward() throws ApplicationException {
        try {
            this.response.sendRedirect(this.fromURL);
        }
        catch (IOException io) {
            throw new ApplicationException(io.getMessage(), io);
        }
        return this.response;
    }

    public String getCurrentURL() {
        return URLEncoder.encode(this.currentURL, StandardCharsets.UTF_8);
    }

    public String getFromURL() {
        return URLEncoder.encode(this.fromURL, StandardCharsets.UTF_8);
    }
}

