/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.tinystruct.http.Cookie;

public class CookieImpl
implements Cookie {
    protected static final String ANCIENT_DATE;
    private static final String COOKIE_DATE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    protected static final ThreadLocal<DateFormat> COOKIE_DATE_FORMAT;
    private static final BitSet domainValid;
    private final String name;
    private String value;
    private boolean httpOnly;
    private boolean wrap;
    private String domain;
    private String path;
    private long maxAge;
    private boolean secure;

    public CookieImpl(String name) {
        this.name = name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String value() {
        return this.value;
    }

    @Override
    public void setValue(String value) {
        this.value = value;
    }

    @Override
    public boolean wrap() {
        return this.wrap;
    }

    @Override
    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    @Override
    public String domain() {
        return this.domain;
    }

    @Override
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public void setPath(String path) {
        this.path = path;
    }

    @Override
    public long maxAge() {
        return this.maxAge;
    }

    @Override
    public void setMaxAge(long maxAge) {
        this.maxAge = maxAge;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public void setSecure(boolean secure) {
        this.secure = secure;
    }

    @Override
    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    @Override
    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public String toString() {
        String path;
        String domain;
        long maxAge;
        StringBuffer header = new StringBuffer();
        header.append(this.name);
        header.append('=');
        String value = this.value;
        if (value != null && !value.isEmpty()) {
            this.validateCookieValue(value);
            header.append(value);
        }
        if ((maxAge = this.maxAge) > -1L) {
            header.append("; Max-Age=");
            header.append(maxAge);
            header.append("; Expires=");
            if (maxAge == 0L) {
                header.append(ANCIENT_DATE);
            } else {
                COOKIE_DATE_FORMAT.get().format(new Date(System.currentTimeMillis() + maxAge * 1000L), header, new FieldPosition(0));
            }
        }
        if ((domain = this.domain) != null && !domain.isEmpty()) {
            this.validateDomain(domain);
            header.append("; Domain=");
            header.append(domain);
        }
        if ((path = this.path) != null && !path.isEmpty()) {
            this.validatePath(path);
            header.append("; Path=");
            header.append(path);
        }
        if (this.secure) {
            header.append("; Secure");
        }
        if (this.httpOnly) {
            header.append("; HttpOnly");
        }
        header.append("; SameSite=");
        header.append("Strict");
        return header.toString();
    }

    private void validateCookieValue(String value) {
        int start = 0;
        int end = value.length();
        if (end > 1 && value.charAt(0) == '\"' && value.charAt(end - 1) == '\"') {
            start = 1;
            --end;
        }
        char[] chars = value.toCharArray();
        for (int i = start; i < end; ++i) {
            char c = chars[i];
            if (c >= '!' && c != '\"' && c != ',' && c != ';' && c != '\\' && c != '\u007f') continue;
            throw new IllegalArgumentException("Invalid Char value:" + Integer.toString(c));
        }
    }

    private void validateDomain(String domain) {
        int cur = -1;
        char[] chars = domain.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int prev = cur;
            cur = chars[i];
            if (!domainValid.get(cur)) {
                throw new IllegalArgumentException("Invalid Domain:" + domain);
            }
            if (!(prev != 46 && prev != -1 || cur != 46 && cur != 45)) {
                throw new IllegalArgumentException("Invalid Domain:" + domain);
            }
            if (prev != 45 || cur != 46) continue;
            throw new IllegalArgumentException("Invalid Domain:" + domain);
        }
        if (cur == 46 || cur == 45) {
            throw new IllegalArgumentException("Invalid Domain:" + domain);
        }
    }

    private void validatePath(String path) {
        char[] chars;
        for (char ch : chars = path.toCharArray()) {
            if (ch >= ' ' && ch <= '~' && ch != ';') continue;
            throw new IllegalArgumentException("Invalid Path:" + path);
        }
    }

    static {
        int c;
        COOKIE_DATE_FORMAT = ThreadLocal.withInitial(() -> {
            SimpleDateFormat df = new SimpleDateFormat(COOKIE_DATE_PATTERN, Locale.US);
            df.setTimeZone(TimeZone.getTimeZone("GMT"));
            return df;
        });
        domainValid = new BitSet(128);
        ANCIENT_DATE = COOKIE_DATE_FORMAT.get().format(new Date(10000L));
        for (c = 48; c <= 57; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 97; c <= 122; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        for (c = 65; c <= 90; c = (int)((char)(c + 1))) {
            domainValid.set(c);
        }
        domainValid.set(46);
        domainValid.set(45);
    }
}

