/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Header
implements Cloneable {
    private static final Map<String, Header> map = new HashMap<String, Header>();
    public static final Header ACCEPT = new Header("Accept", new StandardValue[]{StandardValue.APPLICATION_JSON, StandardValue.APPLICATION_X_WWW_FORM_URLENCODED});
    public static final Header ACCEPT_CHARSET = new Header("Accept-Charset");
    public static final Header ACCEPT_ENCODING = new Header("Accept-Encoding");
    public static final Header ACCEPT_LANGUAGE = new Header("Accept-Language");
    public static final Header ACCEPT_RANGES = new Header("Accept-Ranges");
    public static final Header ACCEPT_PATCH = new Header("Accept-Patch");
    public static final Header ACCESS_CONTROL_ALLOW_CREDENTIALS = new Header("Access-Control-Allow-Credentials");
    public static final Header ACCESS_CONTROL_ALLOW_HEADERS = new Header("Access-Control-Allow-Headers");
    public static final Header ACCESS_CONTROL_ALLOW_METHODS = new Header("Access-Control-Allow-Methods");
    public static final Header ACCESS_CONTROL_ALLOW_ORIGIN = new Header("Access-Control-Allow-Origin");
    public static final Header ACCESS_CONTROL_EXPOSE_HEADERS = new Header("Access-Control-Expose-Headers");
    public static final Header ACCESS_CONTROL_MAX_AGE = new Header("Access-Control-Max-Age");
    public static final Header ACCESS_CONTROL_REQUEST_HEADERS = new Header("Access-Control-Request-Headers");
    public static final Header ACCESS_CONTROL_REQUEST_METHOD = new Header("Access-Control-Request-Method");
    public static final Header AGE = new Header("Age");
    public static final Header ALLOW = new Header("Allow");
    public static final Header AUTHORIZATION = new Header("Authorization");
    public static final Header CACHE_CONTROL = new Header("Cache-Control");
    public static final Header CONNECTION = new Header("Connection");
    public static final Header CONTENT_BASE = new Header("Content-Base");
    public static final Header CONTENT_ENCODING = new Header("Content-Encoding");
    public static final Header CONTENT_LANGUAGE = new Header("Content-Language");
    public static final Header CONTENT_LENGTH = new Header("Content-Length");
    public static final Header CONTENT_DISPOSITION = new Header("Content-Disposition");
    public static final Header CONTENT_LOCATION = new Header("Content-Location");
    public static final Header CONTENT_TRANSFER_ENCODING = new Header("Content-Transfer-Encoding");
    public static final Header CONTENT_MD5 = new Header("Content-MD5");
    public static final Header CONTENT_RANGE = new Header("Content-Range");
    public static final Header CONTENT_TYPE = new Header("Content-Type");
    public static final Header COOKIE = new Header("Cookie");
    public static final Header DATE = new Header("Date");
    public static final Header ETAG = new Header("ETag");
    public static final Header EXPECT = new Header("Expect");
    public static final Header EXPIRES = new Header("Expires");
    public static final Header FROM = new Header("From");
    public static final Header HOST = new Header("Host");
    public static final Header IF_MATCH = new Header("If-Match");
    public static final Header IF_MODIFIED_SINCE = new Header("If-Modified-Since");
    public static final Header IF_NONE_MATCH = new Header("If-None-Match");
    public static final Header IF_RANGE = new Header("If-Range");
    public static final Header IF_UNMODIFIED_SINCE = new Header("If-Unmodified-Since");
    public static final Header LAST_MODIFIED = new Header("Last-Modified");
    public static final Header LOCATION = new Header("Location");
    public static final Header MAX_FORWARDS = new Header("Max-Forwards");
    public static final Header ORIGIN = new Header("Origin");
    public static final Header PRAGMA = new Header("Pragma");
    public static final Header PROXY_AUTHENTICATE = new Header("Proxy-Authenticate");
    public static final Header PROXY_AUTHORIZATION = new Header("Proxy-Authorization");
    public static final Header RANGE = new Header("Range");
    public static final Header REFERER = new Header("Referer");
    public static final Header RETRY_AFTER = new Header("Retry-After");
    public static final Header SEC_WEBSOCKET_KEY1 = new Header("Sec-WebSocket-Key1");
    public static final Header SEC_WEBSOCKET_KEY2 = new Header("Sec-WebSocket-Key2");
    public static final Header SEC_WEBSOCKET_LOCATION = new Header("Sec-WebSocket-Location");
    public static final Header SEC_WEBSOCKET_ORIGIN = new Header("Sec-WebSocket-Origin");
    public static final Header SEC_WEBSOCKET_PROTOCOL = new Header("Sec-WebSocket-Protocol");
    public static final Header SEC_WEBSOCKET_VERSION = new Header("Sec-WebSocket-Version");
    public static final Header SEC_WEBSOCKET_KEY = new Header("Sec-WebSocket-Key");
    public static final Header SEC_WEBSOCKET_ACCEPT = new Header("Sec-WebSocket-Accept");
    public static final Header SEC_FETCH_DEST = new Header("Sec-Fetch-Dest");
    public static final Header SEC_FETCH_MODE = new Header("Sec-Fetch-Mode");
    public static final Header SEC_FETCH_SITE = new Header("Sec-Fetch-Site");
    public static final Header SEC_FETCH_USER = new Header("Sec-Fetch-User");
    public static final Header SERVER = new Header("Server");
    public static final Header SET_COOKIE = new Header("Set-Cookie");
    public static final Header SET_COOKIE2 = new Header("Set-Cookie2");
    public static final Header TE = new Header("TE");
    public static final Header TRAILER = new Header("Trailer");
    public static final Header TRANSFER_ENCODING = new Header("Transfer-Encoding");
    public static final Header UPGRADE = new Header("Upgrade");
    public static final Header UPGRADE_INSECURE_REQUESTS = new Header("Upgrade-Insecure-Requests");
    public static final Header USER_AGENT = new Header("User-Agent");
    public static final Header VARY = new Header("Vary");
    public static final Header VIA = new Header("Via");
    public static final Header WARNING = new Header("Warning");
    public static final Header WEBSOCKET_LOCATION = new Header("WebSocket-Location");
    public static final Header WEBSOCKET_ORIGIN = new Header("WebSocket-Origin");
    public static final Header WEBSOCKET_PROTOCOL = new Header("WebSocket-Protocol");
    public static final Header WWW_AUTHENTICATE = new Header("WWW-Authenticate");
    public static final Header X_REQUESTED_WITH = new Header("X-Requested-With");
    public static final Header X_REQUEST_ID = new Header("X-Request-Id");
    public static final Header NOT_SUPPORTED = new Header("Not-Supported");
    private final String name;
    private StandardValue[] options;
    private Object value;
    private static final Logger logger = Logger.getLogger(Header.class.getName());

    public Header(String name) {
        this.name = name;
        map.put(this.name.toLowerCase(Locale.ROOT), this);
    }

    public Header(String name, StandardValue[] options) {
        this(name);
        this.options = options;
    }

    public static Header value0f(String name) {
        try {
            return Header.valueOf(name.toLowerCase(Locale.ROOT));
        }
        catch (IllegalArgumentException e) {
            return NOT_SUPPORTED;
        }
    }

    private static Header valueOf(String name) {
        Header header = map.get(name);
        if (header == null) {
            throw new IllegalArgumentException();
        }
        return header;
    }

    @Deprecated
    public String toString() {
        return this.name;
    }

    public StandardValue[] getOptions() {
        return this.options;
    }

    public void setOptions(StandardValue[] options) {
        this.options = options;
    }

    public Header set(Object value) {
        this.value = value;
        try {
            return (Header)this.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return this;
        }
    }

    public Header setInt(int readableBytes) {
        this.value = readableBytes;
        try {
            return (Header)this.clone();
        }
        catch (CloneNotSupportedException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return this;
        }
    }

    public Object value() {
        return this.value;
    }

    public String name() {
        return this.name;
    }

    public static enum StandardValue {
        APPLICATION_JSON("application/json"),
        APPLICATION_X_WWW_FORM_URLENCODED("application/x-www-form-urlencoded"),
        BASE64("base64"),
        BINARY("binary"),
        BOUNDARY("boundary"),
        BYTES("bytes"),
        CHARSET("charset"),
        CHUNKED("chunked"),
        CLOSE("close"),
        COMPRESS("compress"),
        CONTINUE("100-continue"),
        DEFLATE("deflate"),
        GZIP("gzip"),
        GZIP_DEFLATE("gzip,deflate"),
        IDENTITY("identity"),
        KEEP_ALIVE("keep-alive"),
        MAX_AGE("max-age"),
        MAX_STALE("max-stale"),
        MIN_FRESH("min-fresh"),
        MULTIPART_FORM_DATA("multipart/form-data"),
        MUST_REVALIDATE("must-revalidate"),
        NO_CACHE("no-cache"),
        NO_STORE("no-store"),
        NO_TRANSFORM("no-transform"),
        NONE("none"),
        ONLY_IF_CACHED("only-if-cached"),
        PRIVATE("private"),
        PROXY_REVALIDATE("proxy-revalidate"),
        PUBLIC("public"),
        QUOTED_PRINTABLE("quoted-printable"),
        S_MAXAGE("s-maxage"),
        TRAILERS("trailers"),
        UPGRADE("Upgrade"),
        WEBSOCKET("WebSocket");

        private final String value;

        private StandardValue(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

