/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.http.Session;

public class MemorySession
implements Session {
    private final Map<String, Object> storage = new ConcurrentHashMap<String, Object>();
    private final String sessionId;
    private long expiry;

    public MemorySession(String sessionId) {
        this.sessionId = sessionId;
        this.expiry = System.currentTimeMillis() + 1800000L;
    }

    @Override
    public String getId() {
        return this.sessionId;
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.storage.put(key, value);
    }

    @Override
    public Object getAttribute(String key) {
        this.expiry = System.currentTimeMillis() + 1800000L;
        return this.storage.get(key);
    }

    @Override
    public void removeAttribute(String key) {
        this.storage.remove(key);
    }

    @Override
    public boolean isExpired() {
        return System.currentTimeMillis() > this.expiry;
    }
}

