/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.MixedFileUpload;
import io.netty.util.CharsetUtil;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.data.Attachment;
import org.tinystruct.data.FileEntity;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.CookieImpl;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.MemorySession;
import org.tinystruct.http.Method;
import org.tinystruct.http.Request;
import org.tinystruct.http.RequestWrapper;
import org.tinystruct.http.Session;
import org.tinystruct.http.SessionManager;
import org.tinystruct.http.Version;

public class RequestBuilder
extends RequestWrapper<FullHttpRequest, Object> {
    private final SessionManager manager = SessionManager.getInstance();
    private final Headers headers = new Headers();
    private final Cookie[] cookies;
    private final HashMap<String, List<String>> params = new HashMap();
    private final boolean secure;
    private List<FileEntity> attachments;
    private String query;
    private Version version;
    private Method method;
    private String uri;
    private String sessionId;
    private String body;
    private static final Logger logger = Logger.getLogger(RequestBuilder.class.getName());

    public RequestBuilder(FullHttpRequest request, boolean secure) {
        super(request);
        QueryStringDecoder q;
        this.uri = request.uri();
        ByteBuf content = request.content();
        content.readableBytes();
        HttpHeaders headers = request.headers();
        headers.forEach(h -> this.headers.add(Header.value0f((String)h.getKey()).set(h.getValue())));
        String value = request.headers().get((CharSequence)HttpHeaderNames.COOKIE);
        Set _cookies = value == null ? Collections.emptySet() : ServerCookieDecoder.STRICT.decode(value);
        int i = _cookies.size();
        this.cookies = new Cookie[i];
        for (io.netty.handler.codec.http.cookie.Cookie _cookie : _cookies) {
            if (_cookie.name().equalsIgnoreCase("JSESSIONID")) {
                this.sessionId = _cookie.value();
            }
            CookieImpl cookie = new CookieImpl(_cookie.name());
            cookie.setValue(_cookie.value());
            cookie.setDomain(_cookie.domain());
            cookie.setHttpOnly(_cookie.isHttpOnly());
            cookie.setMaxAge(_cookie.maxAge());
            cookie.setPath(_cookie.path());
            cookie.setSecure(secure);
            this.cookies[--i] = cookie;
        }
        if (content.capacity() > 0) {
            String contentType = null;
            Object originHeader = this.headers.get(Header.CONTENT_TYPE);
            if (originHeader != null && (contentType = originHeader.toString()).indexOf(59) != -1) {
                contentType = contentType.substring(0, contentType.indexOf(59));
            }
            this.body = content.toString(CharsetUtil.UTF_8);
            switch (Objects.requireNonNull(contentType)) {
                case "multipart/form-data": {
                    Object boundary = null;
                    int index = originHeader.toString().lastIndexOf("boundary=");
                    if (index != -1) {
                        boundary = "--" + originHeader.toString().substring(index + 9);
                        if (((String)boundary).endsWith("\n")) {
                            boundary = ((String)boundary).substring(0, ((String)boundary).length() - 1);
                        }
                        this.body = this.body.substring(0, this.body.indexOf((String)boundary) + ((String)boundary).length());
                    }
                    if (boundary != null && !this.body.startsWith((String)boundary)) {
                        this.parseQuery(this.body, false);
                    }
                    DefaultHttpDataFactory factory = new DefaultHttpDataFactory(16384L);
                    HttpPostRequestDecoder decoder = new HttpPostRequestDecoder((HttpDataFactory)factory, (HttpRequest)request);
                    ArrayList<FileEntity> list = new ArrayList<FileEntity>();
                    while (decoder.hasNext()) {
                        InterfaceHttpData fileData = decoder.next();
                        if (fileData == null || fileData.getHttpDataType() != InterfaceHttpData.HttpDataType.FileUpload) continue;
                        MixedFileUpload upload = (MixedFileUpload)fileData;
                        Attachment attachment = new Attachment();
                        attachment.setContentType(upload.getContentType());
                        attachment.setFilename(upload.getFilename());
                        attachment.setContentTransferEncoding(upload.getContentTransferEncoding());
                        try {
                            attachment.setContent(upload.get());
                        }
                        catch (IOException e) {
                            logger.log(Level.SEVERE, e.getMessage(), e);
                        }
                        list.add(attachment);
                    }
                    this.attachments = list;
                    break;
                }
                case "text/plain": 
                case "application/json": {
                    break;
                }
                default: {
                    this.parseQuery(content.toString(CharsetUtil.UTF_8), false);
                }
            }
        }
        if (!(q = this.parseQuery(request.uri(), true)).path().isEmpty()) {
            this.query = q.parameters().get("q") != null ? (String)((List)q.parameters().get("q")).get(0) : "";
        }
        this.secure = secure;
    }

    public RequestBuilder(FullHttpRequest request) {
        this(request, false);
    }

    @Override
    public List<FileEntity> getAttachments() {
        return this.attachments != null ? this.attachments : null;
    }

    private QueryStringDecoder parseQuery(String uri, boolean hasPath) {
        QueryStringDecoder decoder = new QueryStringDecoder(uri, hasPath);
        Map parameters = decoder.parameters();
        for (Map.Entry element : parameters.entrySet()) {
            this.setParameter((String)element.getKey(), (List)element.getValue());
        }
        return decoder;
    }

    private void setParameter(String name, List<String> values) {
        this.params.put(name, values);
    }

    public Session getSession(String id) {
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession(String id, boolean generated) {
        if (this.manager.getSession(id) == null && generated) {
            this.manager.setSession(id, new MemorySession(id));
        }
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession() {
        if (this.sessionId != null) {
            return this.getSession(this.sessionId, true);
        }
        this.sessionId = UUID.randomUUID().toString().replaceAll("-", "");
        return this.getSession(this.sessionId, true);
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String body() {
        return this.body;
    }

    @Override
    public boolean isSecure() {
        return this.secure;
    }

    @Override
    public Nullable stream() {
        return null;
    }

    @Override
    public String[] parameterNames() {
        return this.params.keySet().toArray(new String[0]);
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public Method method() {
        this.setMethod(Method.valueOf(((FullHttpRequest)this.request).method().name()));
        return this.method;
    }

    @Override
    public Request<FullHttpRequest, Object> setMethod(Method method) {
        this.method = method;
        return this;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public Request<FullHttpRequest, Object> setUri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getParameter(String name) {
        if (null != this.params.get(name) && !this.params.get(name).isEmpty()) {
            return this.params.get(name).get(0);
        }
        return null;
    }

    @Override
    public Cookie[] cookies() {
        return this.cookies;
    }
}

