/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpResponseStatus;
import java.io.IOException;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Response;
import org.tinystruct.http.ResponseHeaders;
import org.tinystruct.http.ResponseStatus;
import org.tinystruct.http.ResponseWrapper;
import org.tinystruct.http.Version;

public class ResponseBuilder
extends ResponseWrapper<FullHttpResponse, FullHttpResponse> {
    private ResponseStatus status;
    private Version version;
    private final Headers headers = new Headers();

    public ResponseBuilder(FullHttpResponse response) {
        super(response);
        Object[] names;
        HttpHeaders headers = response.headers();
        for (Object o : names = headers.names().toArray()) {
            String name = o.toString();
            this.headers.add(Header.value0f(name).set(headers.get(name)));
        }
        this.status = ResponseStatus.valueOf(response.status().code());
    }

    public void setContentType(String contentType) {
        ((FullHttpResponse)this.response).headers().add(Header.CONTENT_TYPE.name(), (Object)contentType);
    }

    @Override
    public void addHeader(String header, Object value) {
        if (!((FullHttpResponse)this.response).headers().contains(header)) {
            this.headers.add(new Header(header).set(value));
            if (value instanceof Integer) {
                ((FullHttpResponse)this.response).headers().addInt((CharSequence)header, ((Integer)value).intValue());
            } else {
                ((FullHttpResponse)this.response).headers().add(header, value);
            }
        } else if (((FullHttpResponse)this.response).headers().get(header) == null || !((FullHttpResponse)this.response).headers().get(header).equalsIgnoreCase(value.toString())) {
            if (value instanceof Integer) {
                ((FullHttpResponse)this.response).headers().addInt((CharSequence)header, ((Integer)value).intValue());
            } else {
                ((FullHttpResponse)this.response).headers().add(header, value);
            }
        }
    }

    public void addCookie(Cookie cookie) {
        this.addHeader(Header.SET_COOKIE.name(), cookie.toString());
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public ResponseStatus status() {
        return this.status;
    }

    @Override
    public Response<FullHttpResponse, FullHttpResponse> setStatus(ResponseStatus status) {
        this.status = status;
        ((FullHttpResponse)this.response).setStatus(HttpResponseStatus.valueOf((int)status.code()));
        return this;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public FullHttpResponse get() {
        return (FullHttpResponse)this.response;
    }

    @Override
    public void sendRedirect(String url) throws IOException {
        ((FullHttpResponse)this.response).content().clear();
        ResponseHeaders responseHeaders = new ResponseHeaders(this);
        responseHeaders.add(Header.CONTENT_LENGTH.setInt(0));
        responseHeaders.add(Header.LOCATION.set(url));
        this.setStatus(ResponseStatus.TEMPORARY_REDIRECT);
    }
}

