/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.util.ArrayList;
import java.util.List;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import org.tinystruct.http.Monitor;
import org.tinystruct.http.Session;
import org.tinystruct.http.SessionEvent;
import org.tinystruct.http.SessionListener;
import org.tinystruct.system.scheduling.Scheduler;
import org.tinystruct.system.scheduling.TimeIterator;

public final class SessionManager
implements Monitor<SessionListener> {
    private static final ConcurrentHashMap<String, Session> sessions = new ConcurrentHashMap();
    private final transient List<SessionListener> listeners = new ArrayList<SessionListener>();

    private SessionManager() {
        Scheduler.getInstance().schedule(new ExpirationValidator(), new TimeIterator(0, 0, 0), 1000L);
    }

    public static SessionManager getInstance() {
        return SingletonHolder.manager;
    }

    public void setSession(String sessionId, Session session) {
        sessions.put(sessionId, session);
        SessionEvent event = new SessionEvent(SessionEvent.Type.CREATED, session);
        this.fireEvent(event);
    }

    private void fireEvent(SessionEvent event) {
        if (this.listeners.isEmpty()) {
            return;
        }
        this.listeners.forEach(listener -> listener.onSessionEvent(event));
    }

    public Session getSession(String sessionId) {
        return sessions.get(sessionId);
    }

    public void removeSession(String sessionId) {
        Session session = sessions.remove(sessionId);
        SessionEvent event = new SessionEvent(SessionEvent.Type.DESTROYED, session);
        this.listeners.forEach(listener -> listener.onSessionEvent(event));
    }

    @Override
    public void addListener(SessionListener listener) {
        this.listeners.add(listener);
    }

    private static final class ExpirationValidator
    extends TimerTask {
        private ExpirationValidator() {
        }

        @Override
        public void run() {
            sessions.forEach((sessionId, session) -> {
                if (session.isExpired()) {
                    SessionManager.getInstance().removeSession((String)sessionId);
                }
            });
        }
    }

    private static final class SingletonHolder {
        static final SessionManager manager = new SessionManager();

        private SingletonHolder() {
        }
    }
}

