/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.Proxy;
import java.net.SocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DeflaterInputStream;
import java.util.zip.GZIPInputStream;
import org.brotli.dec.BrotliInputStream;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Attachment;
import org.tinystruct.data.Attachments;
import org.tinystruct.http.Header;
import org.tinystruct.http.client.HttpRequestBuilder;
import org.tinystruct.net.Callback;
import org.tinystruct.transfer.http.upload.ContentDisposition;

@Deprecated(since="2.0", forRemoval=true)
public class URLRequest {
    private static final Logger logger = Logger.getLogger(URLRequest.class.getName());
    private URL url;
    private Proxy proxy = null;
    private HttpURLConnection connection;

    public URLRequest(URL url) {
        this.url = url;
    }

    public URL getUrl() {
        return this.url;
    }

    public URLRequest setUrl(URL url) {
        this.url = url;
        return this;
    }

    public void proxy(Proxy proxy) {
        this.proxy = proxy;
    }

    public byte[] send(HttpRequestBuilder request) throws ApplicationException, URISyntaxException {
        try {
            return this.send(request, new Callback<ByteArrayOutputStream>(){

                @Override
                public byte[] process(ByteArrayOutputStream out) throws ApplicationException {
                    return out.toByteArray();
                }
            });
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    /*
     * Exception decompiling
     */
    public byte[] send(HttpRequestBuilder request, Callback<ByteArrayOutputStream> callback) throws ApplicationException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static InputStream getInputStream(String contentEncoding, InputStream in) throws IOException {
        InputStream decodedStream = null;
        if (contentEncoding != null) {
            switch (contentEncoding) {
                case "gzip": {
                    decodedStream = new GZIPInputStream(in);
                    break;
                }
                case "deflate": {
                    decodedStream = new DeflaterInputStream(in);
                    break;
                }
                case "br": {
                    decodedStream = new BrotliInputStream(in);
                    break;
                }
            }
        }
        InputStream inputToRead = decodedStream != null ? decodedStream : in;
        return inputToRead;
    }

    public int send0(HttpRequestBuilder request) throws ApplicationException {
        return this.send0(request, new Callback<HttpResponse<byte[]>>(){

            @Override
            public byte[] process(HttpResponse<byte[]> data) throws ApplicationException {
                return data.body();
            }
        });
    }

    private int send0(HttpRequestBuilder request, Callback<HttpResponse<byte[]>> callback) throws ApplicationException {
        HttpRequest.Builder builder = HttpRequest.newBuilder();
        try {
            builder.uri(this.url.toURI());
        }
        catch (URISyntaxException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        if (request.headers() != null) {
            request.headers().values().forEach(h -> builder.setHeader(h.name(), h.value().toString()));
        }
        if (request.requestBody() != null) {
            builder.method(request.method().name(), HttpRequest.BodyPublishers.ofByteArray(request.requestBody().getBytes(StandardCharsets.UTF_8)));
        }
        HttpClient.Builder httpClientBuilder = HttpClient.newBuilder();
        if (request.version() != null) {
            switch (request.version()) {
                case HTTP2_0: {
                    httpClientBuilder.version(HttpClient.Version.HTTP_2);
                    break;
                }
                case HTTP1_1: 
                case HTTP1_0: {
                    httpClientBuilder.version(HttpClient.Version.HTTP_1_1);
                    break;
                }
            }
        }
        if (this.proxy != null) {
            httpClientBuilder.proxy(new ProxySelector());
        }
        try {
            HttpResponse<byte[]> response = httpClientBuilder.build().send(builder.build(), HttpResponse.BodyHandlers.ofByteArray());
            return response.statusCode();
        }
        catch (IOException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
        catch (InterruptedException e) {
            throw new ApplicationException(e.getMessage(), e.getCause());
        }
    }

    private String buildQuery(Map<String, Object> parameters) {
        StringBuilder queryBuilder = new StringBuilder();
        parameters.forEach((key, value) -> {
            if (queryBuilder.length() > 0) {
                queryBuilder.append("&");
            }
            queryBuilder.append((String)key).append("=").append(URLEncoder.encode(value.toString(), StandardCharsets.UTF_8));
        });
        return queryBuilder.toString();
    }

    private static /* synthetic */ void lambda$send$2(Attachments attachments, OutputStream writer, String fileBoundary, Attachment attachment) {
        try {
            ContentDisposition contentDisposition = new ContentDisposition(attachments.getParameterName(), attachment.getFilename(), "binary", attachment.get());
            writer.write(("--" + fileBoundary + "\r\n").getBytes(StandardCharsets.UTF_8));
            writer.write(contentDisposition.getTransferBytes());
            writer.flush();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private static /* synthetic */ void lambda$send$1(OutputStream writer, String finalBoundary, String name, Object value) {
        ContentDisposition contentDisposition = new ContentDisposition(name, null, "text/plain", value.toString().getBytes(StandardCharsets.UTF_8));
        try {
            writer.write(("--" + finalBoundary + "\r\n").getBytes(StandardCharsets.UTF_8));
            writer.write(contentDisposition.getTransferBytes());
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    private /* synthetic */ void lambda$send$0(Header h) {
        this.connection.setRequestProperty(h.name(), h.value().toString());
    }

    class ProxySelector
    extends java.net.ProxySelector {
        ProxySelector() {
        }

        @Override
        public List<Proxy> select(URI uri) {
            return List.of(URLRequest.this.proxy);
        }

        @Override
        public void connectFailed(URI uri, SocketAddress sa, IOException ioe) {
        }
    }
}

