/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.client;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Attachment;
import org.tinystruct.data.Attachments;
import org.tinystruct.http.Headers;
import org.tinystruct.http.Method;
import org.tinystruct.http.Version;
import org.tinystruct.transfer.http.upload.ContentDisposition;

public class HttpRequestBuilder {
    private final Map<String, Object> parameters = new HashMap<String, Object>();
    private Attachments attachments;
    private Version version;
    private Headers headers;
    private Method method = Method.GET;
    private String uri;
    private String requestBody;
    private ContentDisposition[] formData;

    public Version version() {
        return this.version;
    }

    public HttpRequestBuilder setVersion(Version version) {
        this.version = version;
        return this;
    }

    public Headers headers() {
        return this.headers;
    }

    public HttpRequestBuilder setHeaders(Headers headers) {
        this.headers = headers;
        return this;
    }

    public Method method() {
        return this.method;
    }

    public HttpRequestBuilder setMethod(Method method) {
        this.method = method;
        return this;
    }

    public String uri() {
        return this.uri;
    }

    public HttpRequestBuilder setUri(String uri) {
        this.uri = uri;
        return this;
    }

    public Map<String, Object> parameters() {
        return this.parameters;
    }

    public HttpRequestBuilder setParameter(String name, Object value) {
        if (name != null && value != null) {
            this.parameters.put(name, value);
        }
        return this;
    }

    public HttpRequestBuilder setFormData(ContentDisposition[] formData) {
        this.formData = formData;
        return this;
    }

    public ContentDisposition[] getFormData() {
        return this.formData;
    }

    public HttpRequestBuilder attach(String parameter, File[] files) throws ApplicationException {
        ArrayList<Attachment> list = new ArrayList<Attachment>();
        for (File file : files) {
            Attachment attachment = new Attachment();
            attachment.setFilename(file.getName());
            try {
                attachment.setContent(Files.readAllBytes(Paths.get(file.getAbsolutePath(), new String[0])));
            }
            catch (IOException e) {
                throw new ApplicationException("Could not read file: " + file.getAbsolutePath());
            }
            list.add(attachment);
        }
        this.attachments = new Attachments(parameter, list);
        return this;
    }

    public Attachments getAttachments() {
        return this.attachments;
    }

    public String requestBody() {
        return this.requestBody;
    }

    public HttpRequestBuilder setRequestBody(String requestBody) {
        this.requestBody = requestBody;
        return this;
    }
}

