/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.security;

import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.Jws;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtParserBuilder;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.MalformedJwtException;
import io.jsonwebtoken.UnsupportedJwtException;
import io.jsonwebtoken.security.Keys;
import io.jsonwebtoken.security.SecretKeyBuilder;
import java.security.Key;
import java.time.Duration;
import java.time.Instant;
import java.util.Base64;
import java.util.Date;
import javax.crypto.SecretKey;
import org.tinystruct.data.component.Builder;

public class JWTManager {
    private static final SecretKey SECRET_KEY = (SecretKey)((SecretKeyBuilder)Jwts.SIG.HS256.key()).build();
    private SecretKey base64Key;

    public void withSecret(String secret) {
        this.base64Key = Keys.hmacShaKeyFor((byte[])Base64.getEncoder().encode(secret.getBytes()));
    }

    public String createToken(String subject, Builder builder, long validity) {
        Instant now = Instant.now();
        Date expiryDate = Date.from(now.plus(Duration.ofHours(validity)));
        JwtBuilder jwtBuilder = Jwts.builder().subject(subject).expiration(expiryDate).issuedAt(Date.from(now));
        builder.forEach((arg_0, arg_1) -> ((JwtBuilder)jwtBuilder).claim(arg_0, arg_1));
        if (this.base64Key != null) {
            jwtBuilder.signWith((Key)this.base64Key);
        } else {
            jwtBuilder.signWith((Key)SECRET_KEY);
        }
        return jwtBuilder.compact();
    }

    public Jws<Claims> parseToken(String compactToken) throws ExpiredJwtException, UnsupportedJwtException, MalformedJwtException, IllegalArgumentException {
        JwtParserBuilder parser = Jwts.parser();
        if (this.base64Key != null) {
            parser.verifyWith(this.base64Key);
        } else {
            parser.verifyWith(SECRET_KEY);
        }
        return parser.build().parseSignedClaims((CharSequence)compactToken);
    }
}

