/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.http.servlet;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.data.Attachment;
import org.tinystruct.data.FileEntity;
import org.tinystruct.http.Cookie;
import org.tinystruct.http.CookieImpl;
import org.tinystruct.http.Header;
import org.tinystruct.http.Headers;
import org.tinystruct.http.MemorySession;
import org.tinystruct.http.Method;
import org.tinystruct.http.Request;
import org.tinystruct.http.RequestWrapper;
import org.tinystruct.http.Session;
import org.tinystruct.http.SessionManager;
import org.tinystruct.http.Version;
import org.tinystruct.http.servlet.MultipartFormData;
import org.tinystruct.transfer.http.upload.ContentDisposition;

public class RequestBuilder
extends RequestWrapper<HttpServletRequest, ServletInputStream> {
    private final SessionManager manager = SessionManager.getInstance();
    private final Headers headers = new Headers();
    private final Cookie[] cookies;
    private final Session memorySession;
    private final boolean secure;
    private Version version;
    private Method method;
    private String uri;
    private static final Logger logger = Logger.getLogger(RequestBuilder.class.getName());

    public RequestBuilder(HttpServletRequest request, boolean secure) {
        super(request);
        Enumeration headerNames = ((HttpServletRequest)this.request).getHeaderNames();
        while (headerNames.hasMoreElements()) {
            try {
                String h = (String)headerNames.nextElement();
                this.headers.add(Header.value0f(h).set(((HttpServletRequest)this.request).getHeader(h)));
            }
            catch (IllegalArgumentException h) {}
        }
        this.setUri(((HttpServletRequest)this.request).getRequestURI());
        this.setMethod(Method.valueOf(((HttpServletRequest)this.request).getMethod()));
        jakarta.servlet.http.Cookie[] _cookies = ((HttpServletRequest)this.request).getCookies();
        if (_cookies != null) {
            int i = _cookies.length;
            this.cookies = new Cookie[i];
            for (jakarta.servlet.http.Cookie _cookie : _cookies) {
                CookieImpl cookie = new CookieImpl(_cookie.getName());
                cookie.setValue(_cookie.getValue());
                cookie.setDomain(_cookie.getDomain());
                cookie.setHttpOnly(_cookie.isHttpOnly());
                cookie.setMaxAge(_cookie.getMaxAge());
                cookie.setPath(_cookie.getPath());
                cookie.setSecure(_cookie.getSecure());
                this.cookies[--i] = cookie;
            }
        } else {
            this.cookies = new Cookie[0];
        }
        HttpSession session = ((HttpServletRequest)this.request).getSession();
        String sessionId = session.getId();
        this.memorySession = this.getSession(sessionId, true);
        Enumeration attributeNames = session.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String s = (String)attributeNames.nextElement();
            this.memorySession.setAttribute(s, session.getAttribute(s));
        }
        this.secure = secure;
    }

    public RequestBuilder(HttpServletRequest request) {
        this(request, false);
    }

    public Session getSession(String id) {
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession(String id, boolean generated) {
        if (this.manager.getSession(id) == null && generated) {
            this.manager.setSession(id, new MemorySession(id));
        }
        return this.manager.getSession(id);
    }

    @Override
    public Session getSession() {
        return this.memorySession;
    }

    @Override
    public String query() {
        return ((HttpServletRequest)this.request).getQueryString();
    }

    @Override
    public String body() {
        StringBuilder lines = new StringBuilder();
        while (true) {
            String line;
            try {
                line = ((HttpServletRequest)this.request).getReader().readLine();
                if (line == null) {
                    break;
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            lines.append(line);
        }
        return lines.toString();
    }

    @Override
    public boolean isSecure() {
        return ((HttpServletRequest)this.request).isSecure();
    }

    @Override
    public ServletInputStream stream() {
        try {
            return ((HttpServletRequest)this.request).getInputStream();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String[] parameterNames() {
        ArrayList<String> names = new ArrayList<String>();
        Enumeration parameterNames = ((HttpServletRequest)this.request).getParameterNames();
        while (parameterNames.hasMoreElements()) {
            names.add((String)parameterNames.nextElement());
        }
        return names.toArray(new String[0]);
    }

    @Override
    public Version version() {
        return this.version;
    }

    @Override
    public void setVersion(Version version) {
        this.version = version;
    }

    @Override
    public Headers headers() {
        return this.headers;
    }

    @Override
    public Method method() {
        return this.method;
    }

    @Override
    public Request<HttpServletRequest, ServletInputStream> setMethod(Method method) {
        this.method = method;
        return this;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public Request<HttpServletRequest, ServletInputStream> setUri(String uri) {
        this.uri = uri;
        return this;
    }

    @Override
    public String getParameter(String name) {
        return ((HttpServletRequest)this.request).getParameter(name);
    }

    @Override
    public List<FileEntity> getAttachments() throws ApplicationException {
        ArrayList<FileEntity> list = new ArrayList<FileEntity>();
        try {
            ContentDisposition e;
            MultipartFormData iterator = new MultipartFormData(this);
            while ((e = iterator.getNextPart()) != null) {
                Attachment attachment = new Attachment();
                attachment.setContentType(e.getContentType());
                attachment.setFilename(e.getFileName());
                attachment.setContent(e.getData());
                list.add(attachment);
            }
        }
        catch (ServletException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
        return list;
    }

    @Override
    public Cookie[] cookies() {
        return this.cookies;
    }
}

