/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.mail;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Folder;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Store;
import java.util.Properties;
import java.util.UUID;
import org.tinystruct.ApplicationException;
import org.tinystruct.mail.Connection;
import org.tinystruct.system.Configuration;

public class POP3Connection
implements Connection {
    private final Configuration<String> config;
    private Session session;
    private Store store;
    private String username;
    private String password;
    private String id;

    public POP3Connection(Configuration<String> properties) throws ApplicationException {
        this.config = properties;
        this.init();
    }

    private void init() throws ApplicationException {
        this.id = UUID.randomUUID().toString().replace("-", "");
        Properties props = System.getProperties();
        boolean isSSL = Boolean.valueOf(this.config.get("mail.ssl.on"));
        String POP3_SOCKETFACTORY_PORT = this.config.get("mail.pop3.socketFactory.port");
        this.username = this.config.get("smtp.auth.user");
        this.password = this.config.get("smtp.auth.pwd");
        props.setProperty("mail.store.protocol", this.config.get("mail.store.protocol"));
        if (isSSL) {
            props.setProperty("mail.pop3.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.pop3.socketFactory.fallback", "false");
            props.setProperty("mail.pop3.socketFactory.port", POP3_SOCKETFACTORY_PORT);
        }
        String host = this.config.get("mail.pop3.host").trim();
        String port = this.config.get("mail.pop3.port").trim();
        String autho = this.config.get("mail.pop3.auth").trim();
        props.setProperty("mail.pop3.host", host.isEmpty() ? "localhost" : host);
        props.setProperty("mail.pop3.port", port.isEmpty() ? "995" : port);
        props.setProperty("mail.pop3.auth", autho.isEmpty() ? "false" : autho);
        if ("true".equalsIgnoreCase(autho)) {
            Authenticator auth = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(POP3Connection.this.username, POP3Connection.this.password);
                }
            };
            this.session = Session.getInstance((Properties)props, (Authenticator)auth);
        } else {
            this.session = Session.getInstance((Properties)props);
        }
        try {
            this.store = this.session.getStore();
            this.store.connect();
        }
        catch (MessagingException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public Store getStore() throws ApplicationException {
        if (!this.store.isConnected()) {
            try {
                this.store.connect();
            }
            catch (MessagingException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        return this.store;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean available() {
        return this.store.isConnected();
    }

    @Override
    public void close() throws MessagingException {
        if (this.available()) {
            this.store.close();
        }
        if (this.store.isConnected()) {
            this.store.close();
        }
    }

    public Folder getFolder(String folder) throws MessagingException {
        return this.store.getFolder(folder);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Connection.PROTOCOL getProtocol() {
        return Connection.PROTOCOL.POP3;
    }

    @Override
    public void send(Message message, Address[] recipients) throws MessagingException {
        throw new MessagingException("POP3 connection does not support sending messages. Use SMTP connection for sending emails.");
    }
}

