/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.mail;

import jakarta.mail.Address;
import jakarta.mail.Authenticator;
import jakarta.mail.Message;
import jakarta.mail.MessagingException;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import java.util.Properties;
import java.util.UUID;
import org.tinystruct.ApplicationException;
import org.tinystruct.mail.Connection;
import org.tinystruct.system.Configuration;

public class SMTPConnection
implements Connection {
    private final Configuration<String> config;
    private Session session;
    private Transport transport;
    private String username;
    private String password;
    private String id;

    public SMTPConnection(Configuration<String> properties) throws ApplicationException {
        this.config = properties;
        this.init();
    }

    private void init() throws ApplicationException {
        this.id = UUID.randomUUID().toString().replace("-", "");
        Properties props = System.getProperties();
        boolean isSSL = Boolean.parseBoolean(this.config.get("mail.ssl.on"));
        String socketFactoryPort = this.config.get("mail.smtp.socketFactory.port");
        this.username = this.config.get("smtp.auth.user");
        this.password = this.config.get("smtp.auth.pwd");
        if (isSSL) {
            props.setProperty("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
            props.setProperty("mail.smtp.socketFactory.fallback", "false");
            props.setProperty("mail.smtp.socketFactory.port", socketFactoryPort);
        }
        String host = this.config.get("mail.smtp.host");
        String port = this.config.get("mail.smtp.port");
        String auth = this.config.get("mail.smtp.auth");
        String from = this.config.get("mail.smtp.from");
        props.setProperty("mail.smtp.from", from.isEmpty() ? this.username : from);
        props.setProperty("mail.smtp.host", host.isEmpty() ? "localhost" : host);
        props.setProperty("mail.smtp.port", port.isEmpty() ? "25" : port);
        props.setProperty("mail.smtp.auth", auth.isEmpty() ? "false" : auth);
        if ("true".equalsIgnoreCase(auth)) {
            Authenticator authenticator = new Authenticator(){

                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(SMTPConnection.this.username, SMTPConnection.this.password);
                }
            };
            this.session = Session.getInstance((Properties)props, (Authenticator)authenticator);
        } else {
            this.session = Session.getInstance((Properties)props);
        }
        try {
            this.transport = this.session.getTransport("smtp");
            this.transport.connect();
        }
        catch (MessagingException e) {
            throw new ApplicationException(e.getMessage(), e);
        }
    }

    public Transport getTransport() throws ApplicationException {
        if (!this.transport.isConnected()) {
            try {
                this.transport.connect();
            }
            catch (MessagingException e) {
                throw new ApplicationException(e.getMessage(), e);
            }
        }
        return this.transport;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public boolean available() {
        return this.transport.isConnected();
    }

    @Override
    public void close() throws MessagingException {
        if (this.available()) {
            this.transport.close();
        }
    }

    @Override
    public void send(Message message, Address[] allRecipients) throws MessagingException {
        this.transport.sendMessage(message, allRecipients);
    }

    public void send(Message message) throws MessagingException {
        Transport.send((Message)message);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Connection.PROTOCOL getProtocol() {
        return Connection.PROTOCOL.SMTP;
    }
}

