/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.mail;

import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.Session;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.mail.Connection;
import org.tinystruct.mail.ConnectionManager;
import org.tinystruct.mail.MailService;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Settings;

public class SimpleMail
implements MailService {
    private static final Logger logger = Logger.getLogger(SimpleMail.class.getName());
    private static final Configuration<String> config = new Settings();
    private static final ConnectionManager manager = ConnectionManager.getInstance();
    private final Properties properties = new Properties();
    private final String username;
    private final String password;
    private String fromName;
    private List<InternetAddress> to;
    private List<InternetAddress> copyTo;
    private List<InternetAddress> behindCopyTo;
    private String content;
    private String subject;
    private List<File> attachments;

    public SimpleMail(String host, int port, String username, String password) {
        this.properties.put("mail.smtp.host", host);
        this.properties.put("mail.smtp.port", (Object)port);
        this.properties.put("mail.smtp.auth", "true");
        this.properties.put("mail.smtp.starttls.enable", "true");
        this.username = username;
        this.password = password;
        this.to = new ArrayList<InternetAddress>();
        this.copyTo = new ArrayList<InternetAddress>();
        this.behindCopyTo = new ArrayList<InternetAddress>();
        this.attachments = new ArrayList<File>();
    }

    public SimpleMail() {
        this(config.get("mail.smtp.host"), Integer.parseInt(config.get("mail.smtp.port")), config.get("mail.smtp.username"), config.get("mail.smtp.password"));
    }

    @Override
    public void sendMail(String to, String subject, String content) throws ApplicationException {
        try {
            this.clearRecipients();
            this.setTo(to);
            this.setSubject(subject);
            this.setBody(content);
            this.send();
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to send email: " + e.getMessage(), e);
        }
    }

    @Override
    public void sendMailWithAttachments(String to, String subject, String content, String[] attachmentPaths) throws ApplicationException {
        try {
            this.clearRecipients();
            this.setTo(to);
            this.setSubject(subject);
            this.setBody(content);
            for (String path : attachmentPaths) {
                this.attachFile(path);
            }
            this.send();
        }
        catch (Exception e) {
            throw new ApplicationException("Failed to send email with attachments: " + e.getMessage(), e);
        }
    }

    public SimpleMail setSubject(String mailSubject) {
        this.subject = mailSubject;
        return this;
    }

    public SimpleMail setBody(String mailBody) {
        this.content = mailBody;
        return this;
    }

    public boolean attachFile(String fileName) {
        try {
            File file = new File(fileName);
            if (file.exists() && file.canRead()) {
                this.attachments.add(file);
                return true;
            }
            logger.warning("Cannot attach file: " + fileName + " (file not found or not readable)");
            return false;
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to attach file: " + fileName, e);
            return false;
        }
    }

    public SimpleMail setFrom(String fromName) {
        this.fromName = fromName;
        return this;
    }

    public SimpleMail setTo(String to) throws ApplicationException {
        try {
            this.clearRecipients();
            this.addTo(to);
            return this;
        }
        catch (Exception e) {
            throw new ApplicationException("Invalid recipient address: " + to, e);
        }
    }

    public SimpleMail addTo(String to) throws ApplicationException {
        try {
            this.to.add(new InternetAddress(to));
            return this;
        }
        catch (Exception e) {
            throw new ApplicationException("Invalid recipient address: " + to, e);
        }
    }

    public SimpleMail addCopyTo(String copyTo) throws ApplicationException {
        try {
            this.copyTo.add(new InternetAddress(copyTo));
            return this;
        }
        catch (Exception e) {
            throw new ApplicationException("Invalid CC address: " + copyTo, e);
        }
    }

    public SimpleMail addBehindCopyTo(String bccTo) throws ApplicationException {
        try {
            this.behindCopyTo.add(new InternetAddress(bccTo));
            return this;
        }
        catch (Exception e) {
            throw new ApplicationException("Invalid BCC address: " + bccTo, e);
        }
    }

    public boolean send() throws ApplicationException {
        if (this.to.isEmpty()) {
            throw new ApplicationException("No recipients specified");
        }
        Connection connection = null;
        try {
            connection = manager.getConnection(config, Connection.PROTOCOL.SMTP);
            Session session = connection.getSession();
            MimeMessage message = new MimeMessage(session);
            if (this.fromName != null) {
                message.setFrom((Address)new InternetAddress(this.username, this.fromName));
            } else {
                message.setFrom((Address)new InternetAddress(this.username));
            }
            InternetAddress[] toAddresses = this.to.toArray(new InternetAddress[0]);
            message.addRecipients(Message.RecipientType.TO, (Address[])toAddresses);
            if (!this.copyTo.isEmpty()) {
                message.addRecipients(Message.RecipientType.CC, (Address[])this.copyTo.toArray(new InternetAddress[0]));
            }
            if (!this.behindCopyTo.isEmpty()) {
                message.addRecipients(Message.RecipientType.BCC, (Address[])this.behindCopyTo.toArray(new InternetAddress[0]));
            }
            message.setSubject(this.subject);
            if (this.attachments.isEmpty()) {
                message.setContent((Object)this.content, "text/html; charset=utf-8");
            } else {
                MimeMultipart multipart = new MimeMultipart();
                MimeBodyPart contentPart = new MimeBodyPart();
                contentPart.setContent((Object)this.content, "text/html; charset=utf-8");
                multipart.addBodyPart((BodyPart)contentPart);
                for (File file : this.attachments) {
                    MimeBodyPart attachmentPart = new MimeBodyPart();
                    attachmentPart.attachFile(file);
                    multipart.addBodyPart((BodyPart)attachmentPart);
                }
                message.setContent((Multipart)multipart);
            }
            connection.send((Message)message, message.getAllRecipients());
            logger.log(Level.INFO, "Email sent successfully to {0}", this.to);
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Failed to send email", e);
            throw new ApplicationException("Failed to send email: " + e.getMessage(), e);
        }
        finally {
            if (connection != null) {
                manager.releaseConnection(connection);
            }
        }
    }

    private void clearRecipients() {
        this.to.clear();
        this.copyTo.clear();
        this.behindCopyTo.clear();
        this.attachments.clear();
    }
}

