/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.mqtt;

import java.util.UUID;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.paho.client.mqttv3.IMqttClient;
import org.eclipse.paho.client.mqttv3.IMqttMessageListener;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.tinystruct.mqtt.MessageListener;
import org.tinystruct.mqtt.MessageQueue;
import org.tinystruct.system.Configuration;
import org.tinystruct.system.Event;

public class MQTTClient
implements MessageQueue<Event> {
    private static final Logger logger = Logger.getLogger(MQTTClient.class.getName());
    protected Configuration<String> config;
    private IMqttClient publisher;

    public MQTTClient(Configuration<String> config) {
        this.config = config;
        try {
            this.publisher = new MqttClient("tcp://" + this.config.get("mqtt.server.host") + ":" + this.config.get("mqtt.server.port"), UUID.randomUUID().toString());
            MqttConnectOptions options = new MqttConnectOptions();
            options.setAutomaticReconnect(true);
            options.setCleanSession(true);
            options.setConnectionTimeout(10);
            this.publisher.connect(options);
        }
        catch (MqttException e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void publish(String topic, String message) {
        if (!this.publisher.isConnected()) {
            return;
        }
        MqttMessage msg = new MqttMessage(message.getBytes());
        msg.setQos(0);
        msg.setRetained(false);
        try {
            this.publisher.publish(topic, msg);
        }
        catch (MqttException e) {
            logger.severe(e.getMessage());
        }
    }

    @Override
    public void subscribe(String topic, final MessageListener<Event> listener) {
        if (!this.publisher.isConnected()) {
            return;
        }
        try {
            this.publisher.subscribe(topic, new IMqttMessageListener(){

                public void messageArrived(String topic, final MqttMessage message) {
                    Event evt = new Event(){

                        @Override
                        public String getName() {
                            return "";
                        }

                        public String getPayload() {
                            return new String(message.getPayload());
                        }
                    };
                    listener.onMessage(topic, evt);
                }
            });
        }
        catch (MqttException e) {
            logger.severe(e.getMessage());
        }
    }

    public void close() {
        try {
            this.publisher.close();
        }
        catch (MqttException e) {
            logger.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

