/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.net.handlers;

import java.io.IOException;
import java.net.URL;
import java.net.URLConnection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.net.URLHandler;
import org.tinystruct.net.URLRequest;
import org.tinystruct.net.URLResponse;
import org.tinystruct.net.handlers.FTPResponse;

public class FTPHandler
implements URLHandler {
    private static final Logger logger = Logger.getLogger(FTPHandler.class.getName());

    @Override
    public URLResponse handleRequest(URLRequest request) throws ApplicationException {
        try {
            URL url = request.getURL();
            URLConnection connection = url.openConnection();
            connection.setDoInput(true);
            connection.setDoOutput(false);
            connection.connect();
            return new FTPResponse(connection);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error handling FTP request", e);
            throw new ApplicationException("Error handling FTP request: " + e.getMessage());
        }
    }

    @Override
    public URLResponse handleRequest(URLRequest request, Consumer<String> consumer) throws ApplicationException {
        throw new ApplicationException("Not implemented yet.");
    }

    @Override
    public CompletableFuture<URLResponse> handleRequestAsync(URLRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.handleRequest(request);
            }
            catch (ApplicationException e) {
                throw new CompletionException(e);
            }
        });
    }
}

