/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.net.handlers;

import java.io.IOException;
import java.io.InputStream;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinystruct.net.URLResponse;

class FTPResponse
implements URLResponse {
    private final int statusCode;
    private final String body;
    private final Map<String, List<String>> headers;

    public FTPResponse(URLConnection connection) throws IOException {
        this.statusCode = 200;
        try (InputStream inputStream = connection.getInputStream();){
            byte[] bytes = inputStream.readAllBytes();
            this.body = new String(bytes);
        }
        this.headers = new HashMap<String, List<String>>();
        Map<String, List<String>> connectionHeaders = connection.getHeaderFields();
        if (connectionHeaders != null) {
            this.headers.putAll(connectionHeaders);
        }
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

