/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.net.handlers;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.function.Consumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.tinystruct.ApplicationException;
import org.tinystruct.net.URLHandler;
import org.tinystruct.net.URLRequest;
import org.tinystruct.net.URLResponse;
import org.tinystruct.net.handlers.FileResponse;

public class FileHandler
implements URLHandler {
    private static final Logger logger = Logger.getLogger(FileHandler.class.getName());

    @Override
    public URLResponse handleRequest(URLRequest request) throws ApplicationException {
        try {
            URL url = request.getURL();
            File file = new File(url.getPath());
            if (!file.exists()) {
                throw new IOException("File not found: " + file.getPath());
            }
            if (!file.canRead()) {
                throw new IOException("Cannot read file: " + file.getPath());
            }
            return new FileResponse(file);
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Error handling file request", e);
            throw new ApplicationException("Error handling file request: " + e.getMessage());
        }
    }

    @Override
    public URLResponse handleRequest(URLRequest request, Consumer<String> consumer) throws ApplicationException {
        throw new ApplicationException("Not implemented yet.");
    }

    @Override
    public CompletableFuture<URLResponse> handleRequestAsync(URLRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            try {
                return this.handleRequest(request);
            }
            catch (ApplicationException e) {
                throw new CompletionException(e);
            }
        });
    }
}

