/*
 * Decompiled with CFR 0.152.
 */
package org.tinystruct.net.handlers;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.tinystruct.net.URLResponse;

class FileResponse
implements URLResponse {
    private final int statusCode;
    private final String body;
    private final Map<String, List<String>> headers;

    public FileResponse(File file) throws IOException {
        this.statusCode = 200;
        this.body = Files.readString(file.toPath());
        this.headers = new HashMap<String, List<String>>();
        this.headers.put("Content-Type", Collections.singletonList(Files.probeContentType(file.toPath())));
        this.headers.put("Content-Length", Collections.singletonList(String.valueOf(file.length())));
        this.headers.put("Last-Modified", Collections.singletonList(new Date(file.lastModified()).toString()));
    }

    @Override
    public int getStatusCode() {
        return this.statusCode;
    }

    @Override
    public String getBody() {
        return this.body;
    }

    @Override
    public Map<String, List<String>> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }
}

